% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.trelliData.R
\name{as.trelliData}
\alias{as.trelliData}
\title{Generate an object from omicsData and/or statRes objects to pass to
  trelliscope building functions}
\usage{
as.trelliData(omicsData = NULL, statRes = NULL)
}
\arguments{
\item{omicsData}{an object of the class 'pepData', 'isobaricpepData',
proData', 'metabData', 'lipidData', or 'nmrData', created by
\code{\link{as.pepData}}, \code{\link{as.isobaricpepData}},
\code{\link{as.proData}}, \code{\link{as.metabData}},
\code{\link{as.lipidData}}, or \code{\link{as.nmrData}}, respectively.}

\item{statRes}{statRes an object of the class 'statRes', created by
\code{\link{imd_anova}}}
}
\value{
An object of class 'trelliData' containing the raw data and optionally, statRes.  
 To be passed to trelliscope building functions.
}
\description{
Either an omicData and/or a statRes object are accepted.
  omicData must be transformed and normalized, unless the data is isobaric
  protein or NMR data. If group_designation() has been run on the omicData
  object to add "main_effects", the resulting plots will include groups. The
  main effects group_designation and e_meta columns are merged to the e_data
  in long format to create the trelliData.omics dataframe, and e_meta is
  merged to statRes in long format to create trelliData.stat dataframe.
}
\examples{
\dontshow{if (requireNamespace("pmartRdata", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
library(pmartRdata)

# Transform the data
omicsData <- edata_transform(omicsData = pep_object, data_scale = "log2")

# Group the data by condition
omicsData <- group_designation(omicsData = omicsData, main_effects = c("Phenotype"))

# Apply the IMD ANOVA filter
imdanova_Filt <- imdanova_filter(omicsData = omicsData)
omicsData <- applyFilt(filter_object = imdanova_Filt, omicsData = omicsData,
                       min_nonmiss_anova = 2)

# Normalize my pepData
omicsData <- normalize_global(omicsData, "subset_fn" = "all", "norm_fn" = "median",
                             "apply_norm" = TRUE, "backtransform" = TRUE)

# Implement the IMD ANOVA method and compute all pairwise comparisons 
# (i.e. leave the `comparisons` argument NULL)
statRes <- imd_anova(omicsData = omicsData, test_method = 'combined')

# Generate the trelliData object
trelliData2 <- as.trelliData(omicsData = omicsData)
trelliData3 <- as.trelliData(statRes = statRes)
trelliData4 <- as.trelliData(omicsData = omicsData, statRes = statRes)
}
\dontshow{\}) # examplesIf}
}
\author{
David Degnan, Lisa Bramer
}
