% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discovery.R
\name{discovery}
\alias{discovery}
\alias{discovery_inductive}
\alias{variant_inductive_imdfb}
\alias{variant_inductive_only_dfg}
\alias{discovery_alpha}
\alias{variant_alpha_classic}
\alias{variant_alpha_plus}
\title{Petri net discovery algorithms}
\usage{
discovery_inductive(
  eventlog,
  parameters = default_parameters(eventlog),
  variant = variant_inductive_imdfb(),
  convert = TRUE
)

variant_inductive_imdfb()

variant_inductive_only_dfg()

discovery_alpha(
  eventlog,
  parameters = default_parameters(eventlog),
  variant = variant_alpha_classic(),
  convert = TRUE
)

variant_alpha_classic()

variant_alpha_plus()
}
\arguments{
\item{eventlog}{A bupaR event log or an R data frame.}

\item{parameters}{A named list of PM4PY parameters (see \link{parameters}) as required by the discovery method.
By default, if the \code{eventlog} is a bupaR event log, the \code{activity_key}, \code{timestamp_key}, and \code{caseid_key} are automatically determined.}

\item{variant}{The variant of the discovery algorithm to be used.
For Inductive Miner currently only \code{variant_inductive_imdfb} is supported.}

\item{convert}{TRUE to automatically convert Python objects to their R equivalent.
If you pass FALSE you can do manual conversion using the \link[reticulate]{r-py-conversion} function.}
}
\value{
A named list with elements \code{petrinet}, \code{initial_marking}, and \code{final_marking} or the original Python object.
}
\description{
PM4PY discovery algorithms that discover a Petri net and its initial and final marking. Currently the Inductive Miner and the Alpha Miner are implemented.
}
\examples{
if (pm4py_available()) {
  library(eventdataR)
  data(patients)

  # As Inductive Miner of PM4PY is not life-cycle aware, keep only `complete` events:
  patients_completes <- patients[patients$registration_type == "complete", ]

  net <- discovery_inductive(patients_completes)

  # Show details of the obtained bupaR Petri net
  print(net$petrinet)

  # initial marking is a character vector
  print(net$initial_marking)

  # final marking is a character vector
  print(net$final_marking)

  # Petri net can be used with other bupaR functions
  petrinetR::render_PN(net$petrinet)

  # Keep an unconverted PM4PY Petri net for use in other PM4PY functions
  py_net <- discovery_inductive(patients_completes, convert = FALSE)
}

}
