% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rdply.r
\name{rdply}
\alias{rdply}
\title{Replicate expression and return results in a data frame.}
\usage{
rdply(.n, .expr, .progress = "none", .id = NA)
}
\arguments{
\item{.n}{number of times to evaluate the expression}

\item{.expr}{expression to evaluate}

\item{.progress}{name of the progress bar to use, see
\code{\link{create_progress_bar}}}

\item{.id}{name of the index column. Pass \code{NULL} to avoid creation of
the index column. For compatibility, omit this argument or pass \code{NA}
to use \code{".n"} as column name.}
}
\value{
a data frame
}
\description{
Evaluate expression n times then combine results into a data frame
}
\details{
This function runs an expression multiple times, and combines the result into
a data frame.  If there are no results, then this function returns a data
frame with zero rows and columns (\code{data.frame()}). This function is
equivalent to \code{\link{replicate}}, but will always return results as a
data frame.
}
\examples{
rdply(20, mean(runif(100)))
rdply(20, each(mean, var)(runif(100)))
rdply(20, data.frame(x = runif(2)))
}
\references{
Hadley Wickham (2011). The Split-Apply-Combine Strategy for Data
  Analysis. Journal of Statistical Software, 40(1), 1-29.
  \url{https://www.jstatsoft.org/v40/i01/}.
}
\keyword{manip}
