% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_mapedit.R
\name{image_view}
\alias{image_view}
\title{Create an interactive map view of an image}
\usage{
image_view(
  img,
  title = "Edit the image",
  show = c("rgb", "index"),
  index = "B",
  max_pixels = 2500000,
  color_regions = custom_palette(),
  ...
)
}
\arguments{
\item{img}{An \code{Image} object.}

\item{title}{The title of the map view. Use to provide short orientations to
the user.}

\item{show}{The display option for the map view. Options are "rgb" for RGB
view and "index" for index view.}

\item{index}{The index to use for the index view. Defaults to "B".}

\item{max_pixels}{integer > 0. Maximum number of cells to use for the plot.
If \code{max_pixels < npixels(img)}, regular sampling is used before plotting.}

\item{color_regions}{The color palette for displaying index values. Default
is \code{\link[=custom_palette]{custom_palette()}}.}

\item{...}{Additional arguments to be passed to \code{\link[mapview:mapView]{mapview::mapview()}}.}
}
\value{
An \code{sf} object, the same object returned by \code{\link[mapedit:editMap]{mapedit::editMap()}}.
}
\description{
This function allows users to interactively edit and analyze an image using
mapview and mapedit packages.
}
\examples{
if(interactive()){
# Example usage:
img <- image_pliman("sev_leaf.jpg")
image_view(img)
}

}
