% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bhit_map.R
\name{bhit_map}
\alias{bhit_map}
\title{Platemap to identify 'hits' following a B-score normalisation}
\usage{
bhit_map(
  data,
  well,
  plate = 96,
  threshold = 2,
  palette = "Spectral",
  eps = 0.01,
  maxiter = 10,
  trace.iter = FALSE,
  na.rm = TRUE,
  ...
)
}
\arguments{
\item{data}{Vector of numerical values}

\item{well}{Vector of well identifiers, e.g "A01"}

\item{plate}{Number of wells in whole plate (96, 384 or 1536)}

\item{threshold}{Standard deviations from the plate average to indicate a hit.
default is set to +/- 2 SD.}

\item{palette}{RColorBrewer palette}

\item{eps}{real number greater than 0. A tolerance for divergence}

\item{maxiter}{int, the maximum number of iterations}

\item{trace.iter}{Boolean, should progress in convergence be reported?}

\item{na.rm}{Boolean, should missing values be removed?}

\item{...}{additional parameters to plot wrappers}
}
\value{
ggplot plot
}
\description{
Produces a platemap with colours indicating wells above or below selected threshold
after normalising for systematic plate effects via B-score smooth. The threshold is
definined calculated from a z-score, i.e plus or minus standard deviations from the
plate mean.
}
\examples{
df <- data.frame(vals = rnorm(384),
   well = num_to_well(1:384, plate = 384))

bhit_map(data = df$vals,
   well = df$well,
   plate = 384,
   threshold = 3)
}
