% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tuzet.R
\name{PhotosynTuzet}
\alias{PhotosynTuzet}
\title{Coupled leaf gas exchange model with Tuzet stomatal conductance}
\usage{
PhotosynTuzet(g1 = 8, Ca = 400, psis = 0, kl = 2, sf = 3,
  psif = -2, ...)
}
\arguments{
\item{g1}{The slope parameter. Note that the default value should be much higher than that used in the Medlyn et al. (2011) model to give comparable predictions.}

\item{Ca}{Atmospheric CO2 concentration.}

\item{psis}{Soil water potential (MPa). Note that soil-to-root hydraulic conductance is not implemented.}

\item{kl}{Leaf-specific hydraulic conductance (mmol m-2 s-1 MPa-1)}

\item{sf}{Shape parameter (-) of sigmoidal function of leaf water potential (see Tuzet et al. 2003)}

\item{psif}{Leaf water potential at which stomatal conductance is 50\% of maximum (MPa).}

\item{\dots}{All other arguments in \code{\link{Photosyn}}}
}
\description{
An implementation of the coupled photosynthesis - stomatal conductance model, using the Tuzet et al. (2003) model of stomatal conductance. Accepts all arguments of \code{\link{Photosyn}} (except \code{gsmodel}, of course).
}
