% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gantt.R
\name{ganttAddTask}
\alias{ganttAddTask}
\title{Add a task to a gantt object}
\usage{
ganttAddTask(g, description = "", start = NA, end = NA, done = 0,
  neededBy = NA, key)
}
\arguments{
\item{g}{A \code{gantt} object, i.e. one inheriting from \code{\link{gantt-class}}.}

\item{description}{A character string describing the task.}

\item{start}{A character string indicating the task start time, in a format understood by \code{\link{as.POSIXct}}.
Set to \code{""} (the default) to indicate that \code{description} is a heading, with no start and end time.}

\item{end}{A character string indicating the end time, in a format understood by \code{\link{as.POSIXct}}.}

\item{done}{A numerical value indicating the fraction done.}

\item{neededBy}{An integer indicating a task that depends on the completion of this task. If this is
\code{NA}, then the task is not needed by any other task.}

\item{key}{An optional value indicating the desired key value. If not given, this will default to
one beyond the highest key in \code{g}. Otherwise, if \code{key} is an integer matching
a task that is already in \code{g}, then that task is replaced; otherwise, the new task
is placed between the tasks with integral keys on either side of the task. For example, setting
\code{key=4.5} places this between existing keys 4 and 5 (and then renumbers all keys
to be integers); see \dQuote{Examples}.}
}
\description{
This can be a simpler method than using \code{\link{as.gantt}}, because
tasks can be added one at a time.
}
\examples{
library("plan")
g <- new("gantt")
g <- ganttAddTask(g, "Courses") # no times, so a heading
g <- ganttAddTask(g, "Physical Oceanography", "2016-09-03", "2016-12-05")
g <- ganttAddTask(g, "Chemistry Oceanography", "2016-09-03", "2016-12-05")
g <- ganttAddTask(g, "Fluid Dynamics", "2016-09-03", "2016-12-05")
g <- ganttAddTask(g, "Biological Oceanography", "2017-01-03", "2017-04-05")
g <- ganttAddTask(g, "Geological Oceanography", "2017-01-03", "2017-04-05")
g <- ganttAddTask(g, "Time-series Analysis", "2017-01-03", "2017-04-05")
g <- ganttAddTask(g, "Research") # no times, so a heading
g <- ganttAddTask(g, "Literature review", "2016-09-03", "2017-04-05")
g <- ganttAddTask(g, "Develop analysis skills", "2016-09-03", "2017-08-01")
g <- ganttAddTask(g, "Thesis work", "2017-01-01", "2018-04-01")
g <- ganttAddTask(g, "Defend thesis proposal", "2017-05-01", "2017-06-01")
g <- ganttAddTask(g, "Write papers & thesis", "2017-05-01", "2018-04-01")
g <- ganttAddTask(g, "Defend thesis", "2018-05-01", "2018-05-15")
# Set 'font' for bold-faced headings
font <- ifelse(is.na(g[["start"]]), 2, 1)
plot(g, ylabel=list(font=font))

}
\seealso{
Other things related to \code{gantt} data: \code{\link{as.gantt}},
  \code{\link{gantt-class}}, \code{\link{gantt}},
  \code{\link{plot,gantt-method}},
  \code{\link{read.gantt}},
  \code{\link{summary,gantt-method}}
}
