% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/solve_fun.R
\name{solve_fun}
\alias{solve_fun}
\title{Solve PK Model Through deSolve Package or Analytical Function}
\usage{
solve_fun(x, time = NULL, params, initParmsfun = NULL, initState,
  dllname, func, initfunc, outnames, method = "lsode", rtol = 1e-08,
  atol = 1e-12, model = NULL, lnparam = F, vars, ...)
}
\arguments{
\item{x}{a list of storing information in the defined sensitivity function.}

\item{time}{a vector to define the given time sequence.}

\item{params}{parameters passed to \code{func}.}

\item{initParmsfun}{a character for the given specific initial parameter function.}

\item{initState}{a vector that define the initial values of state variables for the ODE system.}

\item{dllname}{a string giving the name of the shared library (without extension)
that contains the compiled function.}

\item{func}{the name of the function in the dynamically loaded shared library.}

\item{initfunc}{the name of the initialization function (which initialises values of parameters), as provided in dllname.}

\item{outnames}{the names of output variables calculated in the compiled function \code{func}.}

\item{method}{method used by integrator (\pkg{desolve}).}

\item{rtol}{argument passed to integrator (\pkg{desolve}).}

\item{atol}{argument passed to integrator (\pkg{desolve}).}

\item{model}{the defined analytical equation with functional output.}

\item{lnparam}{a logical value that make the statement of the log-transformed parameter (default FALSE).}

\item{vars}{a character for the selected output.}

\item{...}{additional arguments for deSolve::ode method.}
}
\description{
The \code{solve_fun} can solve time-dependent quantities/concentrations of different variables in PK model
through the imported deSolve function. It can be used to solve the function with analytical solution.
}
\examples{
  q <- "qunif"
  q.arg <- list(list(min = 0.6, max = 1.0),
   list(min = 0.5, max = 1.5),
   list(min = 0.02, max = 0.3),
   list(min = 20, max = 60))

  params <- c("F","KA","KE","V")

  set.seed(1234)
  x <- rfast99(params = params, n = 200, q = q, q.arg = q.arg, rep = 20)

  time <- seq(from = 0.25, to = 12.25, by = 0.5)
  y <- solve_fun(x, model = FFPK, time = time, vars = "output")

  pksim(y) # Visualize uncertainty of model output

}
\references{
K. Soetaert, T. Petzoldt, R.W. Setzer, 2010, Solving differential equations in R: package deSolve,
\emph{J. Stat. Soft.}, 33:9
}
\seealso{
\code{\link{pksim}}
}
