% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aaa-async.R
\name{http_get}
\alias{http_get}
\title{Asynchronous HTTP GET request}
\usage{
http_get(url, headers = character(), file = NULL,
  options = list(timeout = 600), on_progress = NULL)
}
\arguments{
\item{url}{URL to connect to.}

\item{headers}{HTTP headers to send.}

\item{file}{If not \code{NULL}, it must be a string, specifying a file.
The body of the response is written to this file.}

\item{options}{Options to set on the handle. Passed to
\code{\link[curl:handle_setopt]{curl::handle_setopt()}}.}

\item{on_progress}{Progress handler function. It is only used if the
response body is written to a file. See details below.}
}
\value{
Deferred object.
}
\description{
Start an HTTP GET request in the background, and report its completion
via a deferred.
}
\section{Progress bars}{


\code{http_get} can report on the progress of the download, via the
\code{on_progress} argument. This is called with a list, with entries:
\itemize{
\item \code{url}: the specified url to download
\item \code{handle}: the curl handle of the request. This can be queried using
\code{\link[curl:handle_data]{curl::handle_data()}} to get the response status_code, the final
URL (after redirections), timings, etc.
\item \code{file}: the \code{file} argument.
\item \code{total}: total bytes of the response. If this is unknown, it is set
to zero.
\item \code{current}: already received bytes of the response.
}
}

\examples{
\donttest{
afun <- async(function() {
  http_get("https://eu.httpbin.org/status/200")$
    then(function(x) x$status_code)
})
synchronise(afun())
}
}
\seealso{
Other asyncronous HTTP calls: \code{\link{http_head}}
}
\concept{asyncronous HTTP calls}
