% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/medley_all_borders.R
\name{medley_all_borders}
\alias{medley_all_borders}
\title{Apply Cell Borders to All Cells in a Region}
\usage{
medley_all_borders(x, rows = NULL, cols = NULL, horizontal = TRUE,
  vertical = TRUE, part = "body")
}
\arguments{
\item{x}{An object of class dust}

\item{rows}{The rows over which the borders are to be drawn.}

\item{cols}{The cols over which the borders are to be drawn.}

\item{horizontal}{Logical.  Toggles horizontal borders.}

\item{vertical}{Logical. Toggles vertical borders}

\item{part}{A character vector.  May contain any of \code{"body", 
"head", "interfoot", "foot", "table"}.  When any element is 
\code{"table"}, the borders are drawn in all parts of the table.}
}
\description{
For most output, specifying a region of cells with borders
  on all sides is as simple as giving the sprinkle \code{border = "all"}.
  In LaTeX output, however, this can result in thicker than expected 
  vertical borders.  This medley provides a LaTeX save approach to 
  drawing borders on all sides without getting the double vertical 
  border effect.
}
\author{
Benjamin Nutter
}

