% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assert_match_arg.R
\name{assert_match_arg}
\alias{assert_match_arg}
\title{Checkmate Compatible Version of \code{match.arg}}
\usage{
assert_match_arg(x, choices, several_ok = FALSE,
  .var.name = checkmate::vname(x), add = NULL)
}
\arguments{
\item{x}{A character vecotr (of length one unless \code{several.ok} is \code{TRUE}
or \code{NULL}.}

\item{choices}{A character vector of candidate values}

\item{several_ok}{logical specifying if \code{arg} should be allowed to have more 
than one element.}

\item{.var.name}{\code{character(1)}, name of the checked object to print in 
assertions.  Defaults to the heuristic implemented in 
\code{\link[checkmate]{vname}}}

\item{add}{\code{AssertCollection}, Colleciton to store assertion messages.
See \code{link[checkmate]{AssertCollection}}.}

\item{...}{Additional arguments to pass to either 
\code{\link[checkmate]{assertChoice}} or \code{\link[checkmate]{assertSubset}}.
\code{assertChoice} is used when \code{several_ok = FALSE}, otherwise 
\code{assertSubset} is used.}
}
\description{
Matches arguments as \code{match.arg} and returns
the value of the selected argument.
}
\seealso{
\code{\link{match.arg}}, \code{\link[checkmate]{assertChoice}}, 
  \code{\link[checkmate]{assertSubset}}
}

