% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is_best_candidate.R
\name{is_best_candidate}
\alias{is_best_candidate}
\title{Is the experiment the one with the most evidence?}
\usage{
is_best_candidate(experiment, marg_liks)
}
\arguments{
\item{experiment}{a \link{pirouette} experiment,
as can be created by \link{create_experiment}}

\item{marg_liks}{a data frame with marginal likelihoods/evidences.
A test data frame can be created by \link{create_test_marg_liks}}
}
\value{
a boolean
}
\description{
Is the experiment the one with the most evidence?
}
\examples{
if (beautier::is_on_ci()) {

  marg_liks <- create_test_marg_liks(
    site_models = list(beautier::create_jc69_site_model()),
    clock_models = list(beautier::create_strict_clock_model()),
    tree_priors = list(
      beautier::create_yule_tree_prior(),
      beautier::create_bd_tree_prior()
     )
  )

  marg_liks$weight <- c(0.9, 0.1) # in favor of Yule

  experiment_yule <- create_experiment(
    inference_model = beautier::create_inference_model(
      tree_prior = beautier::create_yule_tree_prior()
    )
  )
  create_experiment(
    inference_model = beautier::create_inference_model(
      tree_prior = beautier::create_bd_tree_prior()
    )
  )
}
}
\author{
Richèl J.C. Bilderbeek
}
