% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pin_remove.R
\name{pin_remove}
\alias{pin_remove}
\title{Delete a pin (legacy API)}
\usage{
pin_remove(name, board = NULL)
}
\arguments{
\item{name}{The name for the pin.}

\item{board}{The board from where this pin will be removed.}
}
\description{
Deletes pins from a legacy board.
}
\examples{
\dontshow{if (rlang::is_installed("filelock")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# old API
board_register_local(cache = tempfile())
pin(mtcars)
pin_remove("mtcars")

# new API
board <- board_local()
board \%>\% pin_write(mtcars)
board \%>\% pin_delete("mtcars")
\dontshow{\}) # examplesIf}
}
