% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pima-htsreml.r
\name{pima_htsreml}
\alias{pima_htsreml}
\alias{htsreml}
\title{Higgins-Thompson-Spiegelhalter prediction interval with a REML estimator for \eqn{\hat{\tau}}}
\usage{
pima_htsreml(y, sigma, alpha = 0.05, vartype = c("HK", "SJBC", "CL"),
  maxiter = 100)
}
\arguments{
\item{y}{the effect size estimates vector}

\item{sigma}{the within studies standard errors vector}

\item{alpha}{the alpha level of the prediction interval}

\item{vartype}{the type of the variance estimator for \eqn{\hat{\mu}} (default = "HK"):
\code{HK}, the Hartung and Knapp (2001)'s estimator;
\code{SJBC}, the Sidik and Jonkman (2006)'s bias coreccted estimator;
\code{CL}, a classical estimator, \eqn{(1/\sum{\hat{w}_i})^{-1}};}

\item{maxiter}{the maximum number of iterations}
}
\value{
The average treatment effect estimate \eqn{\hat{\mu}} (\code{muhat}),
the lower and upper prediction limits \eqn{\hat{c}_l} (\code{lpi}) and \eqn{\hat{c}_u} (\code{upi}),
the REML estimator for \eqn{\hat{\tau}} (\code{tau2h}), and the type of the variance estimator (\code{vartype}).
}
\description{
A subroutine for the extended HTS PI (Partlett & Riley, 2017)
}
\examples{
data(sbp, package = "pimeta")
pimeta::htsreml(sbp$y, sbp$sigmak)
# $muhat
# [1] -0.3287403
# $lbpi
# [1] -0.9886995
# $ubpi
# [1] 0.3312188
# $tau2h
# [1] 0.06995102
}
\references{
Partlett, C, and Riley, R. D. (2017).
Random effects meta-analysis: Coverage performance of 95%
confidence and prediction intervals following REML estimation.
\emph{Stat Med.}
\strong{36}(2): 301-317.
}
