% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/P.R
\name{P}
\alias{P}
\alias{PO}
\title{Probability function}
\usage{
P(x)

PO(x, y = NULL)
}
\arguments{
\item{x}{for \code{P}, a logical value. For \code{PO} a numeric value.}

\item{y}{a numeric value or \code{NULL}. If \code{NULL}, the function
will try to calculate \code{PO(L(x),R(x))}, provided the functions
\code{\link{L}} and \code{\link{R}} are defined correctly. This
is the case when \code{PO} is used in the context of a probabilistic
index model fitted with \code{\link{pim}}.}
}
\value{
A numeric value of 0, 0.5 or 1. 1 if x < y, 0.5 if x == y 
and 0 if x > y
}
\description{
This functions transform a comparison or otherwise
logical value to a numeric value for use in a pim.
}
\details{
These functions are constructed purely for notation. 
\code{P} is completely equivalent
to \code{\link{as.numeric}}, apart from an extra control
to check whether it actually makes sense to do so. 
The function \code{PO} is just short for \code{P(x < y) + 0.5*P(x == y)}
}
\examples{
# Check in pim

}
\seealso{
\code{\link{pim}} and \code{\link{pim.formula}} for more information
on how this is used inside a pim context.
}

