% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multi.R
\name{colonnade}
\alias{colonnade}
\alias{squeeze}
\title{Format multiple vectors in a tabular display}
\usage{
colonnade(x, has_row_id = TRUE, width = NULL, ...)

squeeze(x, width = NULL, ...)
}
\arguments{
\item{x}{A list, which can contain matrices or data frames.
If named, the names will be used as title for the pillars. Non-syntactic names
will be escaped.}

\item{has_row_id}{Include a column indicating row IDs? Pass \code{"*"} to mark
the row ID column with a star.}

\item{width}{Default width of the entire output, optional.}

\item{...}{Ignored}
}
\description{
The vectors are formatted to fit horizontally into a user-supplied number of
characters per row.

The \code{colonnade()} function doesn't process the input but returns an object
with a \code{\link[=format]{format()}} and a \code{\link[=print]{print()}} method.
The implementations call \code{squeeze()} to create \link{pillar} objects and fit them to a given width.

The \code{squeeze()} function usually doesn't need to be called manually.
It returns an object suitable for printing and formatting at a fixed width
with additional information about omitted columns, which can be retrieved
via \code{\link[=extra_cols]{extra_cols()}}.
}
\details{
Pillars may be distributed over multiple tiers if
\code{width > getOption("width")}. In this case each tier is at most
\code{getOption("width")} characters wide. The very first step of formatting
is to determine how many tiers are shown at most, and the width of each
tier.

To avoid unnecessary computation for showing very wide colonnades, a first
pass tries to fit all capitals into the tiers.
For each pillar whose capital fits, it is then decided in which tier it is
shown, if at all, and how much horizontal space it may use (either its
minimum or its maximum width).
Remaining space is then distributed proportionally to pillars that do not
use their desired width.

For fitting pillars in one or more tiers, first a check is made
if all pillars fit with their maximum width (e.g.,
\code{option(tibble.width = Inf)} or narrow colonnade).
If yes, this is the resulting fit, no more work needs to be done.
Otherwise, if the maximum width is too wide, the same test
is carried out with the minimum width.
If this is still too wide, this is the resulting fit.
Otherwise, some tiers from the start
will contain pillars with their maximum width, and the remaining tiers
contain pillars with their minimum width.
We determine the cut point where minimum and maximum assignment
agree.

Fitting pillars into tiers is very similar to a word-wrapping algorithm.
In a loop, new tiers are opened if the current tier overflows.
If a column is too wide to fit a single tier, it will never be
displayed, and the colonnade will be truncated there.
This case should never occur with reasonable display widths larger than
30 characters.
Truncation also happens if all available tiers are filled.

The remaining space is distributed from left to right.
Each column gains space proportional to the fraction of missing and
remaining space,
rounded down.
Any space remaining after rounding is distributed from left to right,
one space per column.
}
\examples{
colonnade(list(a = 1:3, b = letters[1:3]))

long_string <- list(paste(letters, collapse = " "))
colonnade(long_string, width = 20)
colonnade(long_string, has_row_id = FALSE, width = 20)

# The width can also be overridden when calling format() or print():
print(colonnade(long_string), width = 20)

# If width is larger than getOption("width"), multiple tiers are created:
colonnade(rep(long_string, 4), width = Inf)
squeeze(colonnade(long_string), width = 20)
}
