% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Steepest_Desc.R
\name{Steepest_Desc}
\alias{Steepest_Desc}
\title{Stand-alone version of steepest descent algorithm}
\usage{
Steepest_Desc(Fmat, S, num.loops)
}
\arguments{
\item{Fmat}{Pigment to Chl a matrix}

\item{S}{Sample data matrix – a matrix of pigment samples}

\item{num.loops}{Number of loops/iterations to perform (no default)}
}
\value{
A list containing
\enumerate{
\item The F matrix (pigment: Chl \emph{a}) ratios
\item RMSE (Root Mean Square Error)
\item Condition number
\item class abundances
\item Figure (plot of results)
\item MAE (Mean Absolute Error)
}
}
\description{
Stand-alone version of steepest descent algorithm
}
\examples{
MC <- Matrix_checks(Sm,Fm)
Snew <- MC$Snew
Fnew <- MC$Fnew
SDRes <- Steepest_Desc(Fnew,Snew, num.loops = 20)

}
