% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phylomatic.R
\name{ph_phylomatic}
\alias{ph_phylomatic}
\title{phylomatic}
\usage{
ph_phylomatic(taxa, phylo, tabular = FALSE, lowercase = FALSE,
  nodes = FALSE)
}
\arguments{
\item{taxa}{(character) all taxa as a character vector (will be written to
a temp file if provided) - OR a path to taxa file. Required. See Details.}

\item{phylo}{(character/phylo) One of: phylogeny as a newick string (will be
written to a temp file) - OR path to file with a newick
string - OR a an \pkg{ape} \code{phylo} object. required.}

\item{tabular}{(logical) Output a tabular representation of phylogeny.
Default: \code{FALSE}}

\item{lowercase}{(logical) Convert all chars in taxa file to lowercase.
Default: \code{FALSE}}

\item{nodes}{(logical) label all nodes with default names.
Default: \code{FALSE}}
}
\description{
Phylomatic is a tool for extracting a phylogeny from a master
phylogeny using only a user-supplied list of taxa.
}
\details{
The \code{taxa} character vector must have each element of the
form \code{family/genus/genus_epithet}. If a file is passed in, each
line should have a \code{family/genus/genus_epithet} string - make sure
only one per line, and a newline (i.e., press ENTER) at the end of
each line
}
\examples{
taxa_file <- system.file("examples/taxa", package = "phylocomr")
phylo_file <- system.file("examples/phylo", package = "phylocomr")

# from strings
(taxa_str <- readLines(taxa_file))
(phylo_str <- readLines(phylo_file))
(tree <- ph_phylomatic(taxa = taxa_str, phylo = phylo_str))

# from files
taxa_file2 <- tempfile()
cat(taxa_str, file = taxa_file2, sep = '\\n')
phylo_file2 <- tempfile()
cat(phylo_str, file = phylo_file2, sep = '\\n')
(tree <- ph_phylomatic(taxa = taxa_file2, phylo = phylo_file2))

if (requireNamespace("ape")) {
  library(ape)
  plot(read.tree(text = tree))
}
}
\references{
Phylomatic is also available as a web service
(https://github.com/camwebb/phylomatic-ws) - but is based on a different
code base (https://github.com/camwebb/phylomatic-ws)
See \href{https://doi.org/10.1111/j.1471-8286.2004.00829.x}{ Webb and Donoghue (2005)}
for more information on the goals of Phylomatic.
}
