% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getLabGenealogy.R
\name{getLabGenealogy}
\alias{getLabGenealogy}
\title{Create genealogy}
\usage{
getLabGenealogy(epirecord, epsilon = 0.001234)
}
\arguments{
\item{epirecord}{an epidemiological record, as output from the function \code{\link{makeEpiRecord}}. It must be a matrix of at least two rows and with five columns named "Infectee", "Infector", "InfnTime", "RecTime", "DoneFlag".}

\item{epsilon}{an optional small number to be used for branch lengths which would otherwise be zero.}
}
\value{
An object of class \code{phylo} representing the transmission tree from infectors to infectees.
}
\description{
Create a labelled genealogy from an epidemiological record
}
\examples{
## Generate an epidemiological record:
myepirecord <- makeEpiRecord(c(1,2,3,4))
## make the corresponding genealogy from this record:
mygenealogy <- getLabGenealogy(myepirecord)
plot(mygenealogy)

}
\author{
Caroline Colijn \email{c.colijn@imperial.ac.uk}

Michelle Kendall \email{michelle.louise.kendall@gmail.com}
}
\seealso{
\code{\link{makeEpiRecord}}
}

