% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_latest_resource.R
\name{get_latest_resource}
\alias{get_latest_resource}
\title{Get the latest resource from a data set}
\usage{
get_latest_resource(
  dataset_name,
  rows = NULL,
  row_filters = NULL,
  col_select = NULL,
  include_context = TRUE
)
}
\arguments{
\item{dataset_name}{Name of the dataset as found on \href{https://www.opendata.nhs.scot/}{NHS Open Data platform} (character).}

\item{rows}{(optional) Maximum number of rows to return (integer).}

\item{row_filters}{(optional) A named list or vector specifying values of columns/fields to keep (e.g., list(Date = 20220216, Sex = "Female")).}

\item{col_select}{(optional) A character vector containing the names of desired columns/fields (e.g., c("Date", "Sex")).}

\item{include_context}{(optional) If \code{TRUE}, additional information about the resource will be added as columns to the data, including the resource ID, the resource name, the creation date, and the last modified/updated date.}
}
\value{
a \link[tibble:tibble-package]{tibble} with the data
}
\description{
Returns the latest resource available in a dataset.
}
\details{
There are some datasets on the open data platform that
keep historic resources instead of updating existing ones.
For these it is useful to be able to retrieve the latest
resource. As of 1.8.2024 these data sets include:
\itemize{
\item gp-practice-populations
\item gp-practice-contact-details-and-list-sizes
\item nhsscotland-payments-to-general-practice
\item dental-practices-and-patient-registrations
\item general-practitioner-contact-details
\item prescribed-dispensed
\item dispenser-location-contact-details
\item community-pharmacy-contractor-activity
}
}
\examples{
dataset_name <- "gp-practice-contact-details-and-list-sizes"

data <- get_latest_resource(dataset_name)

filters <- list("Postcode" = "DD11 1ES")
wanted_cols <- c("PracticeCode", "Postcode", "Dispensing")

filtered_data <- get_latest_resource(
  dataset_name = dataset_name,
  row_filters = filters,
  col_select = wanted_cols
)

}
