% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/icnirp.r
\name{ICNIRP}
\alias{ICNIRP}
\title{Constructor of ICNIRP 2004 weighted waveband}
\usage{
ICNIRP(norm = 270, w.low = 210, w.high = 400)
}
\arguments{
\item{norm}{normalization wavelength (nm)}

\item{w.low}{short-end boundary wavelength (nm)}

\item{w.high}{long-end boundary wavelength (nm)}
}
\value{
a waveband object defining wavelength range, weighting function
and normalization wavelength.
}
\description{
ICNIRP 2004 BSWF waveband constructor. This BSWF is used for the
determination of exposure limits (EL) for workers, and includes a safety margin
as it is based on eye and the non-pathologic response of the most sensitive
human skin types when not tanned.
}
\examples{
ICNIRP()

}
\references{
INTERNATIONAL COMMISSION ON NON-IONIZING RADIATION PROTECTION (2004) ICNIRP
  GUIDELINES ON LIMITS OF EXPOSURE TO ULTRAVIOLET RADIATION OF WAVELENGTHS
  BETWEEN 180 nm AND 400 nm (INCOHERENT OPTICAL RADIATION). HEALTH PHYSICS
  87(2):171-186.
  \url{http://www.icnirp.org/cms/upload/publications/ICNIRPUV2004.pdf}
}
\seealso{
\code{\link{new_waveband}}  \code{\link{waveband}}

Other BSWF weighted wavebands: \code{\link{CH4}},
  \code{\link{CIE}}, \code{\link{DNA_GM}},
  \code{\link{DNA_N}}, \code{\link{DNA_P}},
  \code{\link{FLAV}}, \code{\link{GEN_G}},
  \code{\link{GEN_M}}, \code{\link{GEN_T}},
  \code{\link{PG}}
}
