#' Spectral data for LEDs array supplied by Norlux
#' 
#' Datasets containing the wavelengths and tabulated values spectral emittance 
#' for the NHXRGB0905005 light emitting diodes (LEDs) arrays from Norlux (USA). 
#' Data are normalized to one at the wavelength of maximum emission.
#' 
#' The variables are as follows:
#' \itemize{
#'   \item w.length (nm)  
#'   \item s.e.irrad (W m-2 nm-1)
#' }
#' 
#' @docType data
#' @keywords datasets
#' @format A vector of character strings.
#' 
#' @examples 
#' norlux
#' leds.mspct[norlux]
#' 
#' @note
#' Norlux is now part of Thomas Research Products.
#' \url{http://www.trpssl.com/}
#' 
"norlux"
