% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read-libradtran.r
\name{read_uvspec_disort}
\alias{read_uvspec_disort}
\title{Read libRadtran's uvspec output file.}
\usage{
read_uvspec_disort(file, date = NULL, geocode = NULL, label = NULL,
  tz = NULL, locale = readr::default_locale(), multiplier = 0.001,
  qty = "irradiance")
}
\arguments{
\item{file}{character string}

\item{date}{a \code{POSIXct} object, but if \code{NULL} the date stored in
file is used, and if \code{NA} no date variable is added}

\item{geocode}{A data frame with columns \code{lon} and \code{lat}.}

\item{label}{character string, but if \code{NULL} the value of \code{file} is
used, and if \code{NA} the "what.measured" attribute is not set.}

\item{tz}{character Time zone is by default read from the file.}

\item{locale}{The locale controls defaults that vary from place to place. The
default locale is US-centric (like R), but you can use
\code{\link[readr]{locale}} to create your own locale that controls things
like the default time zone, encoding, decimal mark, big mark, and day/month
names.}

\item{multiplier}{numeric A multiplier for conversion into W m-2 nm-1, as
the units of expression of the output from "uvspec" depend on the units
in which the extraterrestrial solar spectrum data is expressed.}

\item{qty}{character "uvspec" returns both irradiance and intensity with
solver "disort".}
}
\value{
A source_spct object.
}
\description{
Read and parse a text file output by libRadtran's uvspec routine for a solar 
spectrum simulation. The output of uvspec depends among other things on the
solver used. We define a family of functions, each function for a different
solver.
}
\note{
Currently only "irradiance" is suported as qty argument as intensity is
  not supported by classes and methods in package 'photobiology'.

Tested only with libRadtran version 2.0
}
\references{
\url{http://www.r4photobiology.info} \url{http://www.libradtran.org}
}

