% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s.e.irrad2rgb.R
\name{s_e_irrad2rgb}
\alias{s_e_irrad2rgb}
\title{Spectrum to rgb color conversion}
\usage{
s_e_irrad2rgb(w.length, s.e.irrad, sens = photobiology::ciexyzCMF2.spct,
  color.name = NULL, check = TRUE)
}
\arguments{
\item{w.length}{numeric array of wavelengths (nm)}

\item{s.e.irrad}{numeric array of spectral irradiance values}

\item{sens}{a chroma_spct object with variables w.length, x, y, and z, giving
the CC or CMF definition (default is the proposed human CMF according to
CIE 2006.)}

\item{color.name}{character string for naming the rgb color definition}

\item{check}{logical indicating whether to check or not spectral data}
}
\value{
A color defined using \code{\link[grDevices]{rgb}}. The numeric
  values of the RGB components can be obtained using function
  \code{\link[grDevices]{col2rgb}}.
}
\description{
Calculates rgb values from spectra based on human color matching functions
(CMF) or chromaticity coordinates (CC). A CMF takes into account luminous
sensitivity, while a CC only the color hue. This function, in contrast to
that in package pavo does not normalize the values to equal luminosity, so
using a CMF as input gives the expected result. Another difference is that it
allows the user to choose the chromaticity data to be used. The data used by
default is different, and it corresponds to the whole range of CIE standard,
rather than the reduced range 400 nm to 700 nm. The wavelength limits are not
hard coded, so the function could be used to simulate vision in other
organisms as long as pseudo CMF or CC data are available for the simulation.
}
\note{
Very heavily modified from Chad Eliason's
  \email{cme16@zips.uakron.edu} spec2rgb function in package \code{Pavo}.
}
\examples{
my.color <-
    with(sun.data, s_e_irrad2rgb(w.length, s.e.irrad, color.name="sunWhite"))
col2rgb(my.color)

}
\references{
CIE(1932). Commission Internationale de l'Eclairage Proceedings,
  1931. Cambridge: Cambridge University Press.

Color matching functions obtained from Colour and Vision Research
Laboratory online data respository at \url{http://www.cvrl.org/}.
}
\seealso{
\url{http://www.cs.rit.edu/~ncs/color/t_spectr.html}.

Other color functions: \code{\link{rgb_spct}},
  \code{\link{w_length2rgb}},
  \code{\link{w_length_range2rgb}}
}
