% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spct.classes.r
\name{check_spct}
\alias{check_spct}
\alias{check_spct.default}
\alias{check_spct.generic_spct}
\alias{check_spct.calibration_spct}
\alias{check_spct.raw_spct}
\alias{check_spct.cps_spct}
\alias{check_spct.filter_spct}
\alias{check_spct.solute_spct}
\alias{check_spct.reflector_spct}
\alias{check_spct.object_spct}
\alias{check_spct.response_spct}
\alias{check_spct.source_spct}
\alias{check_spct.chroma_spct}
\title{Check validity of spectral objects}
\usage{
check_spct(x, byref, strict.range, force = FALSE, ...)

\method{check_spct}{default}(x, byref = FALSE, strict.range = NA, force = FALSE, ...)

\method{check_spct}{generic_spct}(
  x,
  byref = TRUE,
  strict.range = NA,
  force = FALSE,
  multiple.wl = getMultipleWl(x),
  ...
)

\method{check_spct}{calibration_spct}(
  x,
  byref = TRUE,
  strict.range = getOption("photobiology.strict.range", default = FALSE),
  force = FALSE,
  multiple.wl = getMultipleWl(x),
  ...
)

\method{check_spct}{raw_spct}(
  x,
  byref = TRUE,
  strict.range = getOption("photobiology.strict.range", default = FALSE),
  force = FALSE,
  multiple.wl = getMultipleWl(x),
  ...
)

\method{check_spct}{cps_spct}(
  x,
  byref = TRUE,
  strict.range = getOption("photobiology.strict.range", default = FALSE),
  force = FALSE,
  multiple.wl = getMultipleWl(x),
  ...
)

\method{check_spct}{filter_spct}(
  x,
  byref = TRUE,
  strict.range = getOption("photobiology.strict.range", default = FALSE),
  force = FALSE,
  multiple.wl = getMultipleWl(x),
  ...
)

\method{check_spct}{solute_spct}(
  x,
  byref = TRUE,
  strict.range = getOption("photobiology.strict.range", default = FALSE),
  force = FALSE,
  multiple.wl = getMultipleWl(x),
  ...
)

\method{check_spct}{reflector_spct}(
  x,
  byref = TRUE,
  strict.range = getOption("photobiology.strict.range", default = FALSE),
  force = FALSE,
  multiple.wl = getMultipleWl(x),
  ...
)

\method{check_spct}{object_spct}(
  x,
  byref = TRUE,
  strict.range = getOption("photobiology.strict.range", default = FALSE),
  force = FALSE,
  multiple.wl = getMultipleWl(x),
  ...
)

\method{check_spct}{response_spct}(
  x,
  byref = TRUE,
  strict.range = NA,
  force = FALSE,
  multiple.wl = getMultipleWl(x),
  ...
)

\method{check_spct}{source_spct}(
  x,
  byref = TRUE,
  strict.range = getOption("photobiology.strict.range", default = FALSE),
  force = FALSE,
  multiple.wl = getMultipleWl(x),
  ...
)

\method{check_spct}{chroma_spct}(
  x,
  byref = TRUE,
  strict.range = getOption("photobiology.strict.range", default = FALSE),
  force = FALSE,
  multiple.wl = getMultipleWl(x),
  ...
)
}
\arguments{
\item{x}{An R object}

\item{byref}{logical indicating if new object will be created by reference or
by copy of \code{x}}

\item{strict.range}{logical indicating whether off-range values result in an
error instead of a warning, with \code{NA} a message is issued on failure.}

\item{force}{logical If \code{TRUE} check is done even if checks are
disabled.}

\item{...}{additional parameters possible in derived methods}

\item{multiple.wl}{numeric Maximum number of repeated w.length entries with
same value.}
}
\description{
Check that an R object contains the expected data members and within range
values in them. For wavelengths also check if ordered and if unique or not.
}
\details{
These methods are exported and can be called by user code if needed,
  for example, when the checks have been disabled by setting an R option
  with \code{\link{disable_check_spct}}.
}
\section{Methods (by class)}{
\itemize{
\item \code{check_spct(default)}: Default for generic function.

\item \code{check_spct(generic_spct)}: Specialization for generic_spct.

\item \code{check_spct(calibration_spct)}: Specialization for calibration_spct.

\item \code{check_spct(raw_spct)}: Specialization for raw_spct.

\item \code{check_spct(cps_spct)}: Specialization for cps_spct.

\item \code{check_spct(filter_spct)}: Specialization for filter_spct.

\item \code{check_spct(solute_spct)}: Specialization for solute_spct.

\item \code{check_spct(reflector_spct)}: Specialization for reflector_spct.

\item \code{check_spct(object_spct)}: Specialization for object_spct.

\item \code{check_spct(response_spct)}: Specialization for response_spct.

\item \code{check_spct(source_spct)}: Specialization for source_spct.

\item \code{check_spct(chroma_spct)}: Specialization for chroma_spct.

}}
\examples{
check_spct(sun.spct)

check_spct(sun.spct)
# try(check_spct(-sun.spct))
# try(check_spct((sun.spct[1, "w.length"] <- 1000)))

}
\seealso{
Other data validity check functions: 
\code{\link{check_spectrum}()},
\code{\link{check_w.length}()},
\code{\link{enable_check_spct}()}
}
\concept{data validity check functions}
