% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spct.metadata.r
\name{add_attr2tb}
\alias{add_attr2tb}
\alias{when_measured2tb}
\alias{geocode2tb}
\alias{lonlat2tb}
\alias{lon2tb}
\alias{lat2tb}
\alias{address2tb}
\alias{what_measured2tb}
\alias{how_measured2tb}
\alias{normalized2tb}
\alias{scaled2tb}
\alias{instr_desc2tb}
\alias{instr_settings2tb}
\alias{BSWF_used2tb}
\alias{filter_properties2tb}
\alias{solute_properties2tb}
\alias{Tfr_type2tb}
\alias{Rfr_type2tb}
\alias{time_unit2tb}
\alias{comment2tb}
\title{Copy attributes from members of a generic_mspct}
\usage{
add_attr2tb(
  tb = NULL,
  mspct,
  col.names = NULL,
  idx = "spct.idx",
  unnest = FALSE
)

when_measured2tb(mspct, tb = NULL, col.names = "when.measured", idx = NULL)

geocode2tb(mspct, tb = NULL, col.names = "geocode", idx = "spct.idx")

lonlat2tb(mspct, tb = NULL, col.names = c("lon", "lat"), idx = "spct.idx")

lon2tb(mspct, tb = NULL, col.names = "lon", idx = "spct.idx")

lat2tb(mspct, tb = NULL, col.names = "lat", idx = "spct.idx")

address2tb(mspct, tb = NULL, col.names = "address", idx = "spct.idx")

what_measured2tb(
  mspct,
  tb = NULL,
  col.names = "what.measured",
  idx = "spct.idx"
)

how_measured2tb(mspct, tb = NULL, col.names = "how.measured", idx = "spct.idx")

normalized2tb(mspct, tb = NULL, col.names = "normalized", idx = "spct.idx")

scaled2tb(mspct, tb = NULL, col.names = "scaled", idx = "spct.idx")

instr_desc2tb(mspct, tb = NULL, col.names = "instr.desc", idx = "spct.idx")

instr_settings2tb(
  mspct,
  tb = NULL,
  col.names = "instr.settings",
  idx = "spct.idx"
)

BSWF_used2tb(mspct, tb = NULL, col.names = "BSWF.used", idx = "spct.idx")

filter_properties2tb(
  mspct,
  tb = NULL,
  col.names = "filter.properties",
  idx = "spct.idx"
)

solute_properties2tb(
  mspct,
  tb = NULL,
  col.names = "solute.properties",
  idx = "spct.idx"
)

Tfr_type2tb(mspct, tb = NULL, col.names = "Tfr.type", idx = "spct.idx")

Rfr_type2tb(mspct, tb = NULL, col.names = "Rfr.type", idx = "spct.idx")

time_unit2tb(mspct, tb = NULL, col.names = "time.unit", idx = "spct.idx")

comment2tb(mspct, tb = NULL, col.names = "comment", idx = "spct.idx")
}
\arguments{
\item{tb}{tibble or data.frame to which to add the data (optional).}

\item{mspct}{generic_mspct Any collection of spectra.}

\item{col.names}{named character vector Name(s) of metadata attributes
to copy, while if named, the names provide the name for the column.}

\item{idx}{character Name of the column with the names of the members of the
collection of spectra.}

\item{unnest}{logical Flag controlling if metadata attributes that are lists
of values should be returned in a list column or in separate columns.}
}
\value{
A tibble With the metadata attributes in separate new variables.
}
\description{
Copy metadata attributes from members of a generic_mspct object into a tibble
or data.frame.
}
\details{
The attributes are copied to a column in a tibble or data frame. If
  the \code{tb} formal parameter receives \code{NULL} as argument, a new
  \code{tibble} will be created. If an existing \code{data.frame} or
  \code{tibble} is passed as argument, new columns are added to it. However,
  the number of rows in the argument passed to \code{tb} must match the
  number of spectra in the argument passed to \code{mspct}. Only in the case
  of method \code{add_attr2tb()} if the argument to \code{col.names} is a
  named vector, the names of members are used as names for the columns
  created. This permits setting any valid name for the new columns. If the
  vector passed to \code{col.names} has no names the names of the attributes
  are used for the new columns. If the fields of the attributes are unnested
  their names are used as names for the columns.

  Valid accepted as argument to \code{col.names} are \code{NULL},
  \code{"lon"}, \code{"lat"}, \code{"address"}, \code{"geocode"},
  \code{"where.measured"}, \code{"when.measured"}, \code{"what.measured"},
  \code{"how.measured"}, \code{"comment"}, \code{"normalised"},
  \code{"normalized"}, \code{"scaled"}, \code{"bswf.used"},
  \code{"instr.desc"}, \code{"instr.settings"},
  \code{solute.properties}, \code{"filter.properties"},
  \code{"Tfr.type"}, \code{"Rfr.type"}, \code{"time.unit"}.
}
\note{
The order of the first two arguments
  is reversed in \code{add_attr2tb()} compared to the other functions. This
  is to allow its use in 'pipes', while the functions for single attributes
  are expected to be used mostly to create new tibbles.
}
\examples{

library(dplyr)

my.mspct <- source_mspct(list(sun1 = sun.spct, sun2 = sun.spct * 2))
q_irrad(my.mspct) \%>\%
  add_attr2tb(my.mspct, c(lat = "latitude",
                          lon = "longitude",
                          when.measured = "time"))

when_measured2tb(my.mspct)

}
\seealso{
Other measurement metadata functions: 
\code{\link{getFilterProperties}()},
\code{\link{getHowMeasured}()},
\code{\link{getInstrDesc}()},
\code{\link{getInstrSettings}()},
\code{\link{getSoluteProperties}()},
\code{\link{getWhatMeasured}()},
\code{\link{getWhenMeasured}()},
\code{\link{getWhereMeasured}()},
\code{\link{get_attributes}()},
\code{\link{isValidInstrDesc}()},
\code{\link{isValidInstrSettings}()},
\code{\link{select_spct_attributes}()},
\code{\link{setFilterProperties}()},
\code{\link{setHowMeasured}()},
\code{\link{setInstrDesc}()},
\code{\link{setInstrSettings}()},
\code{\link{setSoluteProperties}()},
\code{\link{setWhatMeasured}()},
\code{\link{setWhenMeasured}()},
\code{\link{setWhereMeasured}()},
\code{\link{spct_attr2tb}()},
\code{\link{spct_metadata}()},
\code{\link{subset_attributes}()},
\code{\link{trimInstrDesc}()},
\code{\link{trimInstrSettings}()}
}
\concept{measurement metadata functions}
