% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ph_i.R
\name{ph_i}
\alias{ph_i}
\title{Phosphor Font Icons}
\usage{
ph_i(
  name,
  weight = c("light", "regular", "thin", "bold", "fill"),
  size = c("lg", "xxs", "xs", "sm", "xl", "1x", "2x", "3x", "4x", "5x", "6x", "7x",
    "8x", "9x", "10x"),
  color = NULL,
  ...
)
}
\arguments{
\item{name}{Name of the icon to use.}

\item{weight}{Weight of icon (from thinnest to thickest): \code{thin}, \code{light} (default), \code{regular}, \code{bold} or \code{fill}.}

\item{size}{Size of icon.}

\item{color}{Color of icon: use valid HTML color or hex code.}

\item{...}{Attributes passed to the \code{i} tag.}
}
\value{
An HTML tag.
}
\description{
Create a Phosphor icon with font files.
}
\examples{
library(phosphoricons)

ph_i("airplane-tilt")
ph_i("airplane-tilt", weight = "thin")
ph_i("airplane-tilt", weight = "bold")
ph_i("house")
ph_i("house", color = "#F45B69")
ph_i("cake")
ph_i("cake", size = "xl")
ph_i("cake", size = "10x")
}
