% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/par_init.R
\name{par_init}
\alias{par_init}
\title{Calculate initial set of parameters.}
\usage{
par_init(data = stop("A dataset must be provided"), parametersfixed = NA,
  help = FALSE)
}
\arguments{
\item{data}{Dataset generated with add_phenology()}

\item{parametersfixed}{Set of fixed parameters}

\item{help}{If TRUE, an help is displayed}
}
\value{
The initial set of parameters
}
\description{
This function is used to generate a first set of parameters
that is expected to be not to far from the final.\cr
The parameters can be:\cr
Min, MinE, MinB, PMin, PMinB, PMinE\cr
Max\cr
Begin, Peak, Flat, End\cr
theta\cr
Alpha, Beta, tau, Phi, Delta\cr
Alpha1, Beta1, tau1, Phi1, Delta1\cr
Alpha2, Beta2, tau2, Phi2, Delta2\cr
Alpha3, Beta3, tau3, Phi3, Delta3\cr
The parameters Max, Min, MinE, MinB, and Peak can be followed with _ and the name of the rookery.
}
\details{
par_init calculates initial set of parameters.
}
\examples{
\dontrun{
library(phenology)
# Read a file with data
Gratiot<-read.delim("http://max2.ese.u-psud.fr/epc/conservation/BI/Complete.txt", header=FALSE)
data(Gratiot)
# Generate a formatted list nammed data_Gratiot
data_Gratiot<-add_phenology(Gratiot, name="Complete",
		reference=as.Date("2001-01-01"), format="\%d/\%m/\%Y")
# Generate initial points for the optimisation
parg<-par_init(data_Gratiot, parametersfixed=NULL)
# Run the optimisation
result_Gratiot<-fit_phenology(data=data_Gratiot,
		parametersfit=parg, parametersfixed=NULL, trace=1)
data(result_Gratiot)
# Plot the phenology and get some stats
output<-plot(result_Gratiot)
}
}
\author{
Marc Girondot
}

