% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sleepStages.R
\name{sleepStages}
\alias{sleepStages}
\title{Plot sleep stages in individual flies}
\usage{
sleepStages(data, n.days, channel = 1, photoperiod = 12)
}
\arguments{
\item{data}{Input data file. The input for this function must be the output of the function trimData(). See ??trimData().}

\item{n.days}{The number of cycles for which sleep stages must be visualized.}

\item{channel}{The channel number of the fly to be visualized.}

\item{photoperiod}{This value determines the duration of photo-phase and scoto-phase of the 24-h day. Defaults to 12.}
}
\value{
A \code{plot} with the day-time and night-time sleep stages of a user defined fly for the number of cycles provided by the user.
}
\description{
Allows users to generate individual plots of sleep stages in flies. Sleep stages are defined as follows: 5 to 30-min as short sleep (light blue), 30 to 60-min as intermediate sleep (medium blue) and 60 to 720-min as deep sleep (dark blue). Activity is plotted in red. The input for this function must be the output of the trimData() function. The output of this function is a plot. Note: At this moment, this works accurately only for 24-h days.
}
\examples{
\dontrun{
td <- trimData(data = df, start.date = "19 Dec 20", start.time = "21:00",
n.days = 2, bin = 1, t.cycle = 24)
sleepStages(data = td, n.days = 1)
}
}
