% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/peakIdentifier.R
\name{peakIdentifier}
\alias{peakIdentifier}
\title{Phase identifier for activity data}
\usage{
peakIdentifier(
  data,
  filt.order = 3,
  filt.length = 51,
  min.peak.dist = 100,
  peak.ht.scal = 0.5,
  ZT = c(0, 12),
  rm.channels = c()
)
}
\arguments{
\item{data}{Input data file. The input for this function must be the output of the function trimData(). See ??trimData(). This assumes that the output from trimData has data binned in 1-min intervals.}

\item{filt.order}{The filter order. This defaults to 3.}

\item{filt.length}{The length of filter in indices. This defaults to 51.}

\item{min.peak.dist}{The minimum distance between peaks to be picked (in indices). This defaults to 100.}

\item{peak.ht.scal}{A scaling factor to identify peaks. This defaults to 0.5. A value of 0.5 will only find peaks that are at least half as tall as that of the tallest peak.}

\item{ZT}{A vector defining the regions around which the algorithm must looks for peaks. This defaults to c(0,12). The first value in this vector is always assumed to be the morning peak.}

\item{rm.channels}{All the channels that users want to remove from their averaging. This must be a vector, i.e., channels must be separated by commas. For instance, if users choose to remove channels 1 to 5, 25 and 32, then the input should be either c(1,2,3,4,5,25,32) or c(1:5,25,32). This defaults to an empty vector, meaning no individuals are removed from analysis.}
}
\value{
A \code{list} with two items:
\describe{
\item{Plots}{A \code{plotly} \code{htmlwidget} with all the averaged activity overlayed with the smoothed data and markers to point out identified peaks in a 4-by-8 array.}
\item{Data}{A \code{matrix} \code{array} with 32 rows (one for each fly) and 9 columns (Channel/Fly identity, Phases of morning peak onset, maxima and offset, Morning peak height, Phases of evening peak onset, maxima and offset, and Evening peak height (all phases are measured in ZT)).}
}
}
\description{
This function generates a list of outputs. The first element is a plot of raw activity along with the smoothed data and objectively estimated phases of peak of activity data. Smoothing of activity is done using a Savitzky-Golay filter. The input of this function must be the output of the trimData function. This function requires the packages "plotly", "pracma" and "signal". As of now, this function works only for 24-hour T-cycles.
}
\examples{
td <- trimData(data = df, start.date = "19 Dec 20", start.time = "21:00",
n.days = 3, bin = 1, t.cycle = 24)
pks <- peakIdentifier(data = td)
}
