% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predp.R
\name{PredP}
\alias{PredP}
\title{The predictive probability criterion function for Phase II single-arm design}
\usage{
PredP(x, n, nmax, a, b, p0, theta_t)
}
\arguments{
\item{x}{the number of responses among \eqn{n} patients treated by the experimental drug at a certain stage of the trial.}

\item{n}{the number of patients treated by the experimental drug at a certain stage of the trial.}

\item{nmax}{the maximum number of patients treated by the experimental drug.}

\item{a}{the hyperparameter (shape1) of the Beta prior for the experimental drug.}

\item{b}{the hyperparameter (shape2) of the Beta prior for the experimental drug.}

\item{p0}{the the response rate for the standard drug.}

\item{theta_t}{the prespecified target probability; tipically, \eqn{\theta_T = [0.85, 0.95]}.}
}
\value{
\item{prob}{the predictive probability: \eqn{PP = \sum\limits_{y=0}^{n_{max}-n} Pr(Y=y | x) I(\Pr(p > p_0 | Y=y, x) \geq \theta_T) }}
}
\description{
Lee and Liu's criterion function for determining the
trial decision cutoffs based on the predictive probability.
}
\examples{
# Using vague prior Uniform(0,1), i.e. Beta(1,1)
PredP(16, 23, 40, 1, 1, 0.15, 0.9)
}
\references{
Lee, J. J., Liu, D. D. (2008).
A predictive probability design for phase II cancer clinical trials.
\emph{Clinical Trials} \strong{5}: 93-106.

Yin, G. (2012).
\emph{Clinical Trial Design: Bayesian and Frequentist Adaptive Methods.}
New York: Wiley.
}

