/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eps2pgf.ps.resources.fonts;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.sf.eps2pgf.io.StringInputStream;
import net.sf.eps2pgf.ps.GstateStack;
import net.sf.eps2pgf.ps.Path;
import net.sf.eps2pgf.ps.errors.PSError;
import net.sf.eps2pgf.ps.errors.PSErrorInvalidFont;
import net.sf.eps2pgf.ps.errors.PSErrorTypeCheck;
import net.sf.eps2pgf.ps.errors.PSErrorUndefined;
import net.sf.eps2pgf.ps.objects.PSObject;
import net.sf.eps2pgf.ps.objects.PSObjectArray;
import net.sf.eps2pgf.ps.objects.PSObjectDict;
import net.sf.eps2pgf.ps.objects.PSObjectInt;
import net.sf.eps2pgf.ps.objects.PSObjectName;
import net.sf.eps2pgf.ps.objects.PSObjectNull;
import net.sf.eps2pgf.ps.objects.PSObjectString;
import net.sf.eps2pgf.ps.resources.filters.EexecDecode;
import net.sf.eps2pgf.ps.resources.fonts.PSObjectFontMetrics;
import net.sf.eps2pgf.ps.resources.outputdevices.NullDevice;
import net.sf.eps2pgf.util.ArrayStack;
import org.fontbox.afm.CharMetric;
import org.fontbox.afm.FontMetric;
import org.fontbox.util.BoundingBox;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Type1 {
    private Type1() {
    }

    public static void load(PSObjectFontMetrics pSObjectFontMetrics, PSObjectDict pSObjectDict) throws PSError {
        PSObjectDict pSObjectDict2;
        PSObjectDict pSObjectDict3;
        try {
            pSObjectDict3 = pSObjectDict.get("CharStrings").toDict();
        }
        catch (PSErrorUndefined pSErrorUndefined) {
            throw new PSErrorInvalidFont("Required entry (CharStrings) not defined");
        }
        try {
            pSObjectDict2 = pSObjectDict.get("Private").toDict();
        }
        catch (PSErrorUndefined pSErrorUndefined) {
            throw new PSErrorInvalidFont("Required entry (Private) not defined");
        }
        PSObjectArray pSObjectArray = pSObjectDict2.get("Subrs").toArray();
        pSObjectFontMetrics.setSubrs(Type1.parseSubrs(pSObjectArray));
        pSObjectFontMetrics.setFontMetrics(new FontMetric());
        List<PSObject> list = pSObjectDict3.getItemList();
        try {
            for (int i = 1; i < list.size(); i += 2) {
                PSObjectName pSObjectName = list.get(i).toName();
                PSObjectString pSObjectString = list.get(i + 1).toPSString();
                CharMetric charMetric = Type1.charString2CharMetric(pSObjectFontMetrics, pSObjectName.toString(), pSObjectString.toString());
                pSObjectFontMetrics.getFontMetrics().addCharMetric(charMetric);
            }
        }
        catch (PSError pSError) {
            throw new PSErrorInvalidFont();
        }
    }

    private static List<List<PSObject>> parseSubrs(PSObjectArray pSObjectArray) throws PSError {
        int n = pSObjectArray.size();
        ArrayList<List<PSObject>> arrayList = new ArrayList<List<PSObject>>(n);
        for (int i = 0; i < n; ++i) {
            List<Object> list;
            PSObject pSObject = pSObjectArray.get(i);
            if (pSObject instanceof PSObjectString) {
                PSObjectString pSObjectString = pSObjectArray.get(i).toPSString();
                StringInputStream stringInputStream = new StringInputStream(pSObjectString.toString());
                EexecDecode eexecDecode = new EexecDecode(stringInputStream, 4330, true);
                list = Type1.decodeCharString(eexecDecode);
            } else if (pSObject instanceof PSObjectNull) {
                list = new ArrayList();
            } else {
                throw new PSErrorTypeCheck();
            }
            arrayList.add(list);
        }
        return arrayList;
    }

    public static CharMetric charString2CharMetric(PSObjectFontMetrics pSObjectFontMetrics, String string, String string2) throws PSError {
        int[] nArray;
        int[] nArray2;
        StringInputStream stringInputStream = new StringInputStream(string2);
        EexecDecode eexecDecode = new EexecDecode(stringInputStream, 4330, true);
        List<PSObject> list = Type1.decodeCharString(eexecDecode);
        Path path = Type1.interpretCharString(pSObjectFontMetrics, list, nArray2 = new int[2], nArray = new int[2]);
        double[] dArray = path.getSections().size() > 1 ? path.boundingBox() : new double[4];
        CharMetric charMetric = new CharMetric();
        charMetric.setName(string);
        charMetric.setWx(nArray[0]);
        charMetric.setWy(nArray[1]);
        BoundingBox boundingBox = new BoundingBox();
        boundingBox.setLowerLeftX((float)dArray[0]);
        boundingBox.setLowerLeftY((float)dArray[1]);
        boundingBox.setUpperRightX((float)dArray[2]);
        boundingBox.setUpperRightY((float)dArray[3]);
        charMetric.setBoundingBox(boundingBox);
        return charMetric;
    }

    public static List<PSObject> decodeCharString(InputStream inputStream) throws PSErrorInvalidFont {
        ArrayList<PSObject> arrayList = new ArrayList<PSObject>();
        try {
            int n;
            while ((n = inputStream.read()) != -1) {
                int n2;
                if (n <= 31) {
                    String string;
                    block1 : switch (n) {
                        case 1: {
                            string = "hstem";
                            break;
                        }
                        case 3: {
                            string = "vstem";
                            break;
                        }
                        case 4: {
                            string = "vmoveto";
                            break;
                        }
                        case 5: {
                            string = "rlineto";
                            break;
                        }
                        case 6: {
                            string = "hlineto";
                            break;
                        }
                        case 7: {
                            string = "vlineto";
                            break;
                        }
                        case 8: {
                            string = "rrcurveto";
                            break;
                        }
                        case 9: {
                            string = "closepath";
                            break;
                        }
                        case 10: {
                            string = "callsubr";
                            break;
                        }
                        case 11: {
                            string = "return";
                            break;
                        }
                        case 13: {
                            string = "hsbw";
                            break;
                        }
                        case 14: {
                            string = "endchar";
                            break;
                        }
                        case 21: {
                            string = "rmoveto";
                            break;
                        }
                        case 22: {
                            string = "hmoveto";
                            break;
                        }
                        case 30: {
                            string = "vhcurveto";
                            break;
                        }
                        case 31: {
                            string = "hvcurveto";
                            break;
                        }
                        case 12: {
                            n2 = inputStream.read();
                            switch (n2) {
                                case 0: {
                                    string = "dotsection";
                                    break block1;
                                }
                                case 1: {
                                    string = "vstem3";
                                    break block1;
                                }
                                case 2: {
                                    string = "hstem3";
                                    break block1;
                                }
                                case 6: {
                                    string = "seac";
                                    break block1;
                                }
                                case 7: {
                                    string = "sbw";
                                    break block1;
                                }
                                case 12: {
                                    string = "div";
                                    break block1;
                                }
                                case 16: {
                                    string = "callothersubr";
                                    break block1;
                                }
                                case 17: {
                                    string = "pop";
                                    break block1;
                                }
                                case 33: {
                                    string = "setcurrentpoint";
                                    break block1;
                                }
                            }
                            throw new PSErrorInvalidFont();
                        }
                        default: {
                            throw new PSErrorInvalidFont();
                        }
                    }
                    arrayList.add(new PSObjectName(string, false));
                    continue;
                }
                if (n <= 246) {
                    arrayList.add(new PSObjectInt(n - 139));
                    continue;
                }
                if (n <= 250) {
                    int n3 = inputStream.read();
                    arrayList.add(new PSObjectInt((n - 247) * 256 + n3 + 108));
                    continue;
                }
                if (n <= 254) {
                    int n4 = inputStream.read();
                    arrayList.add(new PSObjectInt(-((n - 251) * 256) - n4 - 108));
                    continue;
                }
                int n5 = inputStream.read();
                n2 = inputStream.read();
                int n6 = inputStream.read();
                int n7 = inputStream.read();
                arrayList.add(new PSObjectInt(n5 << 24 | n2 << 16 | n6 << 8 | n7));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return arrayList;
    }

    public static Path interpretCharString(PSObjectFontMetrics pSObjectFontMetrics, List<PSObject> list, int[] nArray, int[] nArray2) throws PSError {
        GstateStack gstateStack = new GstateStack(new NullDevice());
        ArrayStack<PSObject> arrayStack = new ArrayStack<PSObject>();
        while (!list.isEmpty()) {
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            PSObject pSObject = list.remove(0);
            if (pSObject instanceof PSObjectInt) {
                arrayStack.add(pSObject);
                continue;
            }
            String string = pSObject.toName().toString();
            if (string.equals("rlineto")) {
                n6 = ((PSObject)arrayStack.pop()).toInt();
                n5 = ((PSObject)arrayStack.pop()).toInt();
                gstateStack.current().rlineto(n5, n6);
                continue;
            }
            if (string.equals("hlineto")) {
                n6 = ((PSObject)arrayStack.pop()).toInt();
                gstateStack.current().rlineto(n6, 0.0);
                continue;
            }
            if (string.equals("vlineto")) {
                n6 = ((PSObject)arrayStack.pop()).toInt();
                gstateStack.current().rmoveto(0.0, n6);
                continue;
            }
            if (string.equals("rrcurveto")) {
                n6 = ((PSObject)arrayStack.pop()).toInt();
                n5 = ((PSObject)arrayStack.pop()).toInt();
                n4 = ((PSObject)arrayStack.pop()).toInt();
                n3 = ((PSObject)arrayStack.pop()).toInt();
                n2 = ((PSObject)arrayStack.pop()).toInt();
                n = ((PSObject)arrayStack.pop()).toInt();
                gstateStack.current().rcurveto(n, n2, n + n3, n2 + n4, n + n3 + n5, n2 + n4 + n6);
                continue;
            }
            if (string.equals("vhcurveto")) {
                n6 = 0;
                n5 = ((PSObject)arrayStack.pop()).toInt();
                n4 = ((PSObject)arrayStack.pop()).toInt();
                n3 = ((PSObject)arrayStack.pop()).toInt();
                n2 = ((PSObject)arrayStack.pop()).toInt();
                n = 0;
                gstateStack.current().rcurveto(n, n2, n + n3, n2 + n4, n + n3 + n5, n2 + n4 + n6);
                continue;
            }
            if (string.equals("hvcurveto")) {
                n6 = ((PSObject)arrayStack.pop()).toInt();
                n5 = 0;
                n4 = ((PSObject)arrayStack.pop()).toInt();
                n3 = ((PSObject)arrayStack.pop()).toInt();
                n2 = 0;
                n = ((PSObject)arrayStack.pop()).toInt();
                gstateStack.current().rcurveto(n, n2, n + n3, n2 + n4, n + n3 + n5, n2 + n4 + n6);
                continue;
            }
            if (string.equals("hstem")) {
                ((PSObject)arrayStack.pop()).toInt();
                ((PSObject)arrayStack.pop()).toInt();
                continue;
            }
            if (string.equals("vstem")) {
                ((PSObject)arrayStack.pop()).toInt();
                ((PSObject)arrayStack.pop()).toInt();
                continue;
            }
            if (string.equals("hsbw")) {
                n6 = ((PSObject)arrayStack.pop()).toInt();
                n5 = ((PSObject)arrayStack.pop()).toInt();
                gstateStack.current().setPosition(n5, 0.0);
                nArray[0] = n5;
                nArray[1] = 0;
                nArray2[0] = n6;
                nArray2[1] = 0;
                continue;
            }
            if (string.equals("rmoveto")) {
                n6 = ((PSObject)arrayStack.pop()).toInt();
                n5 = ((PSObject)arrayStack.pop()).toInt();
                gstateStack.current().rmoveto(n5, n6);
                continue;
            }
            if (string.equals("closepath")) {
                gstateStack.current().getPath().closepath();
                continue;
            }
            if (string.equals("endchar")) break;
            if (string.equals("hmoveto")) {
                n6 = ((PSObject)arrayStack.pop()).toInt();
                gstateStack.current().rmoveto(n6, 0.0);
                continue;
            }
            if (string.equals("vmoveto")) {
                n6 = ((PSObject)arrayStack.pop()).toInt();
                gstateStack.current().rmoveto(0.0, n6);
                continue;
            }
            if (string.equals("hstem3")) {
                for (n6 = 0; n6 < 6; ++n6) {
                    arrayStack.pop();
                }
                continue;
            }
            if (string.equals("vstem3")) {
                for (n6 = 0; n6 < 6; ++n6) {
                    arrayStack.pop();
                }
                continue;
            }
            if (string.equals("callsubr")) {
                n6 = ((PSObject)arrayStack.pop()).toInt();
                list.addAll(0, (Collection<PSObject>)pSObjectFontMetrics.getSubrs().get(n6));
                continue;
            }
            if (string.equals("return") || string.equals("pop") || string.equals("callothersubr")) continue;
            System.out.println("-=-=- Unknown command: " + string);
        }
        gstateStack.current().moveto(nArray2[0], nArray2[1]);
        return gstateStack.current().getPath();
    }
}

