/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eps2pgf.ps.resources.shadings;

import net.sf.eps2pgf.ps.errors.PSError;
import net.sf.eps2pgf.ps.objects.PSObjectArray;
import net.sf.eps2pgf.ps.objects.PSObjectDict;
import net.sf.eps2pgf.ps.resources.shadings.Shading;

public class RadialShading
extends Shading {
    private double x0;
    private double y0;
    private double r0;
    private double x1;
    private double y1;
    private double r1;
    private boolean extend0;
    private boolean extend1;

    public RadialShading(PSObjectDict pSObjectDict) throws PSError {
        this.loadCommonEntries(pSObjectDict);
        PSObjectArray pSObjectArray = pSObjectDict.get("Coords").toArray();
        this.x0 = pSObjectArray.get(0).toReal();
        this.y0 = pSObjectArray.get(1).toReal();
        this.r0 = pSObjectArray.get(2).toReal();
        this.x1 = pSObjectArray.get(3).toReal();
        this.y1 = pSObjectArray.get(4).toReal();
        this.r1 = pSObjectArray.get(5).toReal();
        PSObjectArray pSObjectArray2 = pSObjectDict.lookup("Extend").toArray();
        if (pSObjectArray2 == null) {
            this.extend0 = false;
            this.extend1 = false;
        } else {
            this.extend0 = pSObjectArray2.get(0).toBool();
            this.extend1 = pSObjectArray2.get(1).toBool();
        }
    }

    public double[] getCoord(double d) {
        double[] dArray = new double[]{this.x0 + d * (this.x1 - this.x0), this.y0 + d * (this.y1 - this.y0)};
        return dArray;
    }

    public double getRadius(double d) {
        return this.r0 + d * (this.r1 - this.r0);
    }

    public double getSForRadius(double d) {
        if (this.r1 != this.r0) {
            return (d - this.r0) / (this.r1 - this.r0);
        }
        return Double.POSITIVE_INFINITY;
    }

    public double getSForXValue(double d) {
        if (this.x0 != this.x1) {
            return (d - this.x0) / (this.x1 - this.x0);
        }
        return Double.POSITIVE_INFINITY;
    }

    public double getSForYValue(double d) {
        if (this.y0 != this.y1) {
            return (d - this.y0) / (this.y1 - this.y0);
        }
        return Double.POSITIVE_INFINITY;
    }

    public double getSForDistance(double d, double d2, double d3) {
        double d4 = Double.POSITIVE_INFINITY;
        double d5 = this.getSForRadius(0.0);
        if (d5 >= d2 && d5 <= d3 && Math.abs(d5) < Math.abs(d4)) {
            d4 = d5;
        }
        if ((d5 = this.getSForRadius(d)) >= d2 && d5 <= d3 && Math.abs(d5) < Math.abs(d4)) {
            d4 = d5;
        }
        if ((d5 = this.getSForXValue(-d)) >= d2 && d5 <= d3 && Math.abs(d5) < Math.abs(d4)) {
            d4 = d5;
        }
        if ((d5 = this.getSForXValue(d)) >= d2 && d5 <= d3 && Math.abs(d5) < Math.abs(d4)) {
            d4 = d5;
        }
        if ((d5 = this.getSForYValue(-d)) >= d2 && d5 <= d3 && Math.abs(d5) < Math.abs(d4)) {
            d4 = d5;
        }
        if ((d5 = this.getSForYValue(d)) >= d2 && d5 <= d3 && Math.abs(d5) < Math.abs(d4)) {
            d4 = d5;
        }
        return d4;
    }

    public boolean getExtend0() {
        return this.extend0;
    }

    public boolean getExtend1() {
        return this.extend1;
    }
}

