% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/joining.R
\name{run_papers_search}
\alias{run_papers_search}
\title{Run a papers search providing multiple keywords and optionally save results.}
\usage{
run_papers_search(..., get_papers = TRUE, sleep = 3, verbose = TRUE,
  len_keywords = 3, allow_duplicates = TRUE, save_to_rda = FALSE)
}
\arguments{
\item{...}{keywords and keyword levels}

\item{get_papers}{TRUE to retrieve the papers. FALSE, only return the count}

\item{sleep}{delay in seconds between search to OnePetro}

\item{verbose}{TRUE if we want internal messages of the search progress}

\item{len_keywords}{length of the keywords to form the filename of the rda file}

\item{allow_duplicates}{if TRUE, it will allow duplicates based on book_title and
paper_id}

\item{save_to_rda}{logical that indicates if we want to save results to an RDA}
}
\description{
This search performs search of papers by provifing multiple levels of keywords.
The levels can have one or more keywords and the levels can be as many as desired.
Deeper levels makes the search longer.
}
\examples{
\dontrun{
major <- c("gas influx")
minor <- c("overbalanced", "shut in")
lesser <- c("shale", "drilling")
more <- c("gas diffusion", "concentration gradient")
paper_results <- run_papers_search(major, minor, lesser, more,
                                   get_papers = TRUE,       # return with papers
                                   verbose = FALSE,         # show progress
                                   len_keywords = 4,        # naming the data file
                                   allow_duplicates = FALSE) # by paper title and id
}
}
