% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/url.R
\name{make_search_url}
\alias{make_search_url}
\title{Make a search URL for OnePetro}
\usage{
make_search_url(query = NULL, start = NULL, from_year = NULL,
  peer_reviewed = NULL, published_between = NULL, rows = NULL,
  to_year = NULL, dc_type = NULL, how = "any")
}
\arguments{
\item{query}{char         any words that will be searched}

\item{start}{int          optional to set the starting paper}

\item{from_year}{int      optional to indicate starting year}

\item{peer_reviewed}{logical optional, TRUE or FALSE}

\item{published_between}{logical automatic if from_year or to_year are on}

\item{rows}{int           optional. number of papers to retrieve. max=1000}

\item{to_year}{int        optional to indicate end year}

\item{dc_type}{char       optional to indicate if journal, conference paper}

\item{how}{char           default="any". "all" will match exact words}
}
\description{
Create a URL that works in OnePetro website
}
\examples{
\dontrun{
# Example 1
url_1 <- make_search_url(query = "flowing gradient survey", how = "all")
onepetro_page_to_dataframe(url_1)
# Example 2
url_2 <- make_search_url(query = "static  gradient survey", how = "all")
onepetro_page_to_dataframe(url_2)
# Example 3
url_3 <- make_search_url(query = "downhole flowrate measurement",
      how = "all", from_year = 1982, to_year = 2017)
onepetro_page_to_dataframe(url_3)
}
}
