% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accuracyOverall.R
\name{accuracyOverall}
\alias{accuracyOverall}
\alias{wisdomOfCrowd}
\title{Overall Accuracy.}
\usage{
accuracyOverall(predicted, actual, dropUndefined = FALSE)

wisdomOfCrowd(predicted, actual, dropUndefined = FALSE)
}
\arguments{
\item{predicted}{vector of continuous predicted values.}

\item{actual}{vector of actual values.}

\item{dropUndefined}{\code{TRUE} or \code{FALSE}, indicating whether to drop
any undefined values calculated with the accuracy indices.}
}
\value{
\itemize{
  \item \code{ME} = mean error
  \item \code{MAE} = mean absolute error
  \item \code{MSE} = mean squared error
  \item \code{RMSE} = root mean squared error
  \item \code{MPE} = mean percentage error
  \item \code{MAPE} = mean absolute percentage error
  \item \code{sMAPE} = symmetric mean absolute percentage error
  \item \code{MASE} = mean absolute scaled error
  \item \code{RMSLE} = root mean squared log error
  \item \code{rsquared} = \emph{R}-squared
  \item \code{rsquaredAdj} = adjusted \emph{R}-squared
  \item \code{rsquaredPredictive} = predictive \emph{R}-squared
}
}
\description{
Find overall accuracy.
}
\details{
Compute overall accuracy estimates of predicted values in relation to actual
values. Estimates of overall accuracy span all cutoffs. Some accuracy
estimates can be undefined under various circumstances. Optionally, you can
drop undefined values in the calculation of accuracy indices. Note that
dropping undefined values changes the meaning of these indices. Use this
option at your own risk!
}
\examples{
# Prepare Data
data("USArrests")

# Calculate Accuracy
accuracyOverall(predicted = USArrests$Assault, actual = USArrests$Murder)
wisdomOfCrowd(predicted = USArrests$Assault, actual = 200)

}
\seealso{
Mean absolute scaled error (MASE): \cr
\url{https://stats.stackexchange.com/questions/108734/alternative-to-mape-when-the-data-is-not-a-time-series} \cr
\url{https://stats.stackexchange.com/questions/322276/is-mase-specified-only-to-time-series-data} \cr
\url{https://stackoverflow.com/questions/31197726/calculate-mase-with-cross-sectional-non-time-series-data-in-r} \cr
\url{https://stats.stackexchange.com/questions/401759/how-can-mase-mean-absolute-scaled-error-score-value-be-interpreted-for-non-tim} \cr

Predictive R-squared: \cr
\url{https://www.r-bloggers.com/2014/05/can-we-do-better-than-r-squared/} \cr

Other accuracy: 
\code{\link{accuracyAtCutoff}()},
\code{\link{accuracyAtEachCutoff}()},
\code{\link{nomogrammer}()},
\code{\link{optimalCutoff}()},
\code{\link{posttestOdds}()}
}
\concept{accuracy}
