% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulateIndirectEffect.R
\name{simulateIndirectEffect}
\alias{simulateIndirectEffect}
\title{Simulate Indirect Effect.}
\usage{
simulateIndirectEffect(
  N = NA,
  x = NA,
  m = NA,
  XcorM = NA,
  McorY = NA,
  corTotal = NA,
  proportionMediated = NA,
  seed = NA
)
}
\arguments{
\item{N}{Sample size.}

\item{x}{Vector for the predictor variable.}

\item{m}{Vector for the mediating variable.}

\item{XcorM}{Coefficient of the correlation between the predictor variable
and mediating variable.}

\item{McorY}{Coefficient of the correlation between the mediating variable
and outcome variable.}

\item{corTotal}{Size of total effect.}

\item{proportionMediated}{The proportion of the total effect that is mediated.}

\item{seed}{Seed for replicability.}
}
\value{
\itemize{
  \item the correlation between the predictor variable (\code{x}) and the
  mediating variable (\code{m}).
  \item the correlation between the mediating variable (\code{m}) and the
  outcome variable (\code{Y}).
  \item the correlation between the predictor variable (\code{x}) and the
  outcome variable (\code{Y}).
  \item the direct correlation between the predictor variable (\code{x}) and
  the outcome variable (\code{Y}), while controlling for the mediating
  variable (\code{m}).
  \item the indirect correlation between the predictor variable (\code{x})
  and the outcome variable (\code{Y}) through the mediating variable
  (\code{m}).
  \item the total correlation between the predictor variable (\code{x}) and
  the outcome variable (\code{Y}): i.e., the sum of the direct correlation
  and the indirect correlation.
  \item the proportion of the correlation between the predictor variable
  (\code{x}) and the outcome variable (\code{Y}) that is mediated through the
  mediating variable (\code{m}).
}
}
\description{
Simulate indirect effect from mediation analyses.
}
\details{
Co-created by Robert G. Moulder Jr. and Isaac T. Petersen
}
\examples{
#INSERT
}
\seealso{
Other simulation: 
\code{\link{complement}()},
\code{\link{simulateAUC}()}
}
\concept{simulation}
