% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map.R
\name{add_offset}
\alias{add_offset}
\title{Add offset}
\usage{
add_offset(map, offset = 0.1)
}
\arguments{
\item{map}{One map. Required.}

\item{offset}{Numeric value for offset.}
}
\value{
Map object.
}
\description{
Add offset to zero distance markers to allow computation of correlation between maps.
}
\examples{
data(simTetra)
simTetrageno <- bases2genotypes(simTetra, 4)
rfMat <- calcRec(simTetrageno, 4)
split <- splitChr(rfMat, nchr = 7)
split <- sortLeafs(rfMat, split)
map <- pullMap(rfMat, split = split)   
map <- add_offset(map)
}

