% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/item_intercor.R
\name{item_intercor}
\alias{item_intercor}
\title{Mean Inter-Item-Correlation}
\usage{
item_intercor(x, method = c("pearson", "spearman", "kendall"))
}
\arguments{
\item{x}{A matrix as returned by the \code{\link{cor}}-function,
or a data frame with items (e.g. from a test or questionnaire).}

\item{method}{Correlation computation method. May be one of
\code{"spearman"} (default), \code{"pearson"} or \code{"kendall"}.
You may use initial letter only.}
}
\value{
The mean inter-item-correlation value for \code{x}.
}
\description{
Compute various measures of internal consistencies
   for tests or item-scales of questionnaires.
}
\details{
This function calculates a mean inter-item-correlation, i.e.
   a correlation matrix of \code{x} will be computed (unless
   \code{x} is already a matrix as returned by the \code{cor()}-function)
   and the mean of the sum of all item's correlation values is returned.
   Requires either a data frame or a computed \code{cor()}-object.
   \cr \cr
   \dQuote{Ideally, the average inter-item correlation for a set of
   items should be between .20 and .40, suggesting that while the
   items are reasonably homogenous, they do contain sufficiently
   unique variance so as to not be isomorphic with each other.
   When values are lower than .20, then the items may not be
   representative of the same content domain. If values are higher than
   .40, the items may be only capturing a small bandwidth of the construct.}
   \cite{(Piedmont 2014)}
}
\examples{
data(mtcars)
x <- mtcars[, c("cyl", "gear", "carb", "hp")]
item_intercor(x)


}
\references{
Piedmont RL. 2014. Inter-item Correlations. In: Michalos AC (eds) Encyclopedia of Quality of Life and Well-Being Research. Dordrecht: Springer, 3303-3304. \doi{10.1007/978-94-007-0753-5_1493}
}
