% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_SNV_utility_functions.R
\name{getNextLeftFocal}
\alias{getNextLeftFocal}
\title{Expand the neighborhood to the left}
\usage{
getNextLeftFocal(current, absDist)
}
\arguments{
\item{current}{Current SNVs in the neighborhood of focal SNV.}

\item{absDist}{Absolute distance of SNVs from the focal SNV in base pairs.}
}
\value{
An index of a SNV to the left of the neighborhood to be returned to \code{\link{findSNVs}}.
}
\description{
This function tries to expand the neighborhood to the left, when the next SNV
from \code{\link{getNextFromFocal}} is incompatible with each SNV in
the neighborhood of the focal SNV, and this incompatible SNV is to the
right of the neighborhood.
}
\examples{

\dontshow{

data(ex_hapMatSmall_data)

focalSNV = 10
# Proximity to the focal SNV.
absDistFromFocal = abs(ex_hapMatSmall_data$posns - ex_hapMatSmall_data$posns[focalSNV]) 

# Expand the neighborhood to the left.
nxtLeft = getNextLeftFocal(current = c(focalSNV,focalSNV) , absDist = absDistFromFocal)

}

}
\seealso{
\code{\link{findSNVs}}
}
\keyword{internal}
