% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/tabulate.r
\name{generateCustom}
\alias{generateCustom}
\title{Generate peptide and library information for a given scheme}
\usage{
generateCustom(scheme_name = "custom", scheme_def = read.csv(file.choose()),
  k = 1:20, n = 1:25, savefile = TRUE)
}
\arguments{
\item{scheme_name}{The name of the resulting encoding scheme}

\item{scheme_def}{A data frame containing encoding information for the scheme}

\item{k}{peptide lengths to include}

\item{n}{exponents of the library size to include}

\item{savefile}{if true, save the results to an RData file}
}
\value{
TRUE upon completion of the script and output of the CSV files
}
\description{
This function will generate library properties for a custom scheme.  It is primarily intended to be used on http://www.pelica.org.
}
\examples{
\dontrun{
generateCustom()
generateCustom(scheme_name = "NNN", scheme_def = scheme("NNN"))
}
}

