% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_prior.R
\name{sample_prior}
\alias{sample_prior}
\title{Sample from the Prior Distribution}
\usage{
sample_prior(
  method = c("hs", "lasso"),
  prior = switch(method, lasso = c(df = 1, scale = 1), hs = c(df = 1, df_global = 1,
    df_slab = 4, scale_global = 1, scale_slab = 1, par_ratio = NULL)),
  iter = 1000
)
}
\arguments{
\item{method}{Character string, indicating which prior to sample from.
Default: first element of \code{c("hs", "lasso")}.}

\item{prior}{Numeric vector, specifying the prior to use. See \link{brma}
for more details.}

\item{iter}{A positive integer specifying the number of iterations to sample.
Default: 1000}
}
\value{
NULL, function is called for its side-effect of plotting to the
graphics device.
}
\description{
Samples from a prior
distribution with parameters defined in \code{prior}. The result can be plotted
using the \code{\link{plot}} function.
}
\examples{
sample_prior("lasso", iter = 10)
}
