% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/md_stock1_.R
\name{md_stock}
\alias{md_stock}
\title{query stock market data}
\usage{
md_stock(symbol, source = "yahoo", type = "history", freq = "daily",
  date_range = "3y", from = NULL, to = Sys.Date(), adjust = "split",
  print_step = 1L, ...)
}
\arguments{
\item{symbol}{symbols of stock shares.}

\item{source}{the available data sources are 'yahoo' (\url{https://finance.yahoo.com}) and '163' (\url{https://money.163.com}).}

\item{type}{the data type, including history, adjfactor and spot. Default is history.}

\item{freq}{default is daily. It supports daily, weekly and monthly for yahoo data; daily for 163 data.}

\item{date_range}{date range. Available value including '1m'-'11m', 'ytd', 'max' and '1y'-. Default is '3y'.}

\item{from}{the start date. Default is NULL.}

\item{to}{the end date. Default is current system date.}

\item{adjust}{adjust the OHLC prices for split (default), or dividend (both split and dividend). If it is NULL, download the original data.
For the yahoo data, the original data already adjust for split, and use the 'close_adj' column to adjust; for the 163 data, the original doesnot adjust any factors, and use the splits, dividends and issues to adjust.}

\item{print_step}{A non-negative integer. Print symbol name by each print_step iteration. Default is 1L.}

\item{...}{Additional parameters.}
}
\description{
\code{md_stock} provides an interface to query EOD (end of date) stock prices.
}
\examples{
\dontrun{
# Example I
# query history prices from yahoo
dt_yahoo1 = md_stock(symbol=c("^GSPC", "000001.SS"))

# FAANG
FAANG = md_stock(c('FB', 'AMZN', 'AAPL', 'NFLX', 'GOOG'), date_range = 'max')

# for Chinese shares/fund
## the symbol without suffix
dt_yahoo2 = md_stock(c("000001", "^000001", "512510"))
## the symbol with suffix
dt_yahoo3 = md_stock(c("000001.sz", "000001.ss"))

# adjust factors, splits and dividend
dt_adj = md_stock(symbol=c("AAPL", "000001.SZ", "000001.SS"), 
                    type='adjfactor', date_range='max')

 
# Example II
# query history prices from 163
dt1 = md_stock(symbol=c('600000', '000001', '^000001', '^399001'), 
               source="163")

# valuation ratios (pe, pb, ps)
# only available for stock shares in sse and szse
dt2 = md_stock(symbol=c('600000', '000001', '^000001', '^399001'), 
               source="163", valuation = TRUE)
             
             
# Example III
# query spot prices
dt_spot1 = md_stock(symbol=c('600000.SS', '000001.SZ', '000001.SS', '399001.SZ'), 
                    type='spot', source="163")

# query spot prices of all A shares in sse and szse
dt_spot2 = md_stock(symbol='a', source="163", type='spot')
# query spot prices of all A/B shares and index in sse and szse
dt_spot3 = md_stock(symbol=c('a', 'b', 'index'), source="163", type='spot')

# show spot prices and sector/industry
dt_spot4 = md_stock(symbol = c('a', 'b', 'index', 'fund'), source = '163', 
  type = 'spot', show_tags = TRUE)

}

}
