% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotESDA.R
\name{plotESDA}
\alias{plotESDA}
\title{Plots for exploratory spatial data analysis (ESDA)}
\usage{
plotESDA(z, lat, lon, lags, cutoff, width = c(cutoff/20))
}
\arguments{
\item{z}{Vector of numeric values of the variable for with ESDA plots should 
be created.}

\item{lat}{Vector of numeric values containing the y coordinate (latitude) 
of the point locations where the \code{z} variable was observed.}

\item{lon}{Vector of numeric values containing the x coordinate (longitude) 
of the point locations where the \code{z} variable was observed.}

\item{lags}{Numerical vector; upper boundaries of lag-distance classes. See
argument \code{boundaries} of \code{\link[gstat]{variogram}} for more info.}

\item{cutoff}{Integer value defining the spatial separation distance up to 
which point pairs are included in semi-variance estimates. Defaults to the 
length of the diagonal of the box spanning the data divided by three.}

\item{width}{Integer value specifying the width of subsequent distance 
intervals into which data point pairs are grouped for semi-variance 
estimates. Defaults to \code{width = cutoff / 20}.}
}
\value{
Four plots: histogram and density plot, bubble plot, empirical variogram, 
and variogram map.
}
\description{
This function creates four plots for exploratory spatial data analysis 
(ESDA): histogram + density plot, bubble plot, variogram plot, and variogram 
map.
}
\details{
The user should visit the help pages of \code{\link[gstat]{variogram}},
\code{\link[pedometrics]{plotHD}}, \code{\link[sp]{bubble}} and
\code{\link[sp]{spplot}} to obtain more details about the main functions 
used to built \code{plotESDA}.
}
\examples{
# require(gstat)
# data(meuse)
# plotESDA(z = meuse$zinc, lat = meuse$y, lon = meuse$x)

}
\author{
Alessandro Samuel-Rosa \email{alessandrosamuelrosa@gmail.com}
}
\references{
Cressie, N.A.C. (1993) \emph{Statistics for Spatial Data}. New York: John 
Wiley \& Sons, p.900, 1993.

Pebesma, E.J. (2004) Multivariable geostatistics in S: the gstat package. 
\emph{Computers \& Geosciences}, 30:683-691, 2004.

Webster, R. \& Oliver, M.A. \emph{Geostatistics for environmental 
scientists}. Chichester: John Wiley \& Sons, p.315, 2007.
}
\seealso{
\code{\link[gstat]{variogram}}, \code{\link[pedometrics]{plotHD}},
\code{\link[sp]{bubble}}, \code{\link[sp]{spplot}}.
}
\keyword{dplot}

