% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{ccode_democracy}
\alias{ccode_democracy}
\title{Democracy data for all Correlates of War states}
\format{
A data frame with 16536 observations on the following 5 variables.
\describe{
\item{\code{ccode}}{the Correlates of War system code}
\item{\code{year}}{a numeric vector for the year}
\item{\code{v2x_polyarchy}}{the Varieties of Democracy "polyarchy" estimate}
\item{\code{polity2}}{the the \code{polity2} score from the Polity project}
\item{\code{xm_qudsest}}{an extension of the Unified Democracy Scores (UDS) estimates, made possibly by the \code{QuickUDS} package from Xavier Marquez.}
}
}
\usage{
ccode_democracy
}
\description{
These are democracy data for all Correlates of War state system members.
}
\details{
Missing data connote data that are unavailable for various reasons. Either there is no democracy data to code or, in the case of the Polity project, the state
system member is outright not evaluated for the variable.

The Polity data are from 2017. The Varieties of Democracy data are version 10. Xavier Marquez' \code{QuickUDS} estimates (i.e. extensions of Pemstein et al. (2010)) come from a package Marquez makes available on his Github (\url{https://github.com/xmarquez/QuickUDS}).
}
\references{
Coppedge, Michael, John Gerring, Carl Henrik Knutsen, Staffan I. Lindberg,
Jan Teorell, David Altman, Michael Bernhard, M. Steven Fish, Adam Glynn,
Allen Hicken, Anna Luhrmann, Kyle L. Marquardt, Kelly McMann, Pamela
Paxton, Daniel Pemstein, Brigitte Seim, Rachel Sigman, Svend-Erik
Skaaning, Jeffrey Staton, Agnes Cornell, Lisa Gastaldi, Haakon Gjerlow,
Valeriya Mechkova, Johannes von Romer, Aksel Sundtrom, Eitan Tzelgov,
Luca Uberti, Yi-ting Wang, Tore Wig, and Daniel Ziblatt. 2020.
"V-Dem Codebook v10" Varieties of Democracy (V-Dem) Project.

Marshall, Monty G., Ted Robert Gurr, and Keith Jaggers. 2017.
"Polity IV Project: Political Regime Characteristics and Transitions,
1800-2017." Center for Systemic Peace.

Marquez, Xavier, "A Quick Method for Extending the Unified Democracy
Scores" (March 23, 2016).  \doi{10.2139/ssrn.2753830}

Pemstein, Daniel, Stephen Meserve, and James Melton. 2010. "Democratic
Compromise: A Latent Variable Analysis of Ten Measures of Regime Type."
\emph{Political Analysis} 18(4): 426-449.
}
\keyword{datasets}
