% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{RiemmDist}
\alias{RiemmDist}
\title{Riemannian distance HPD-matrices}
\usage{
RiemmDist(A, B)
}
\arguments{
\item{A, B}{Hermitian positive-definite matrices (of equal dimension).}
}
\description{
\code{RiemmDist} calculates the natural Riemannian distance between two Hermitian PD matrices as
in (Bhatia, 2009, Chapter 6).
}
\examples{
 a <- matrix(complex(real = rnorm(9), imaginary = rnorm(9)), nrow = 3)
 A <- t(Conj(a)) \%*\% a
 b <- matrix(complex(real = rnorm(9), imaginary = rnorm(9)), nrow = 3)
 B <- t(Conj(b)) \%*\% b
 RiemmDist(A, B)

}
\references{
Bhatia, R. (2009). \emph{Positive Definite Matrices}. New Jersey: Princeton University Press.
}

