% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eco_micro.R
\name{nti_rc}
\alias{nti_rc}
\alias{plot.NTI_RC}
\title{Calculate b_NTI and RC_bray for each group}
\usage{
nti_rc(
  otutab,
  phylo,
  group_df,
  threads = 1,
  file = NULL,
  rep = 20,
  save = FALSE
)

\method{plot}{NTI_RC}(x, ...)
}
\arguments{
\item{otutab}{an otutab data.frame, samples are columns, taxs are rows.}

\item{phylo}{a phylo object}

\item{group_df}{a dataframe with rowname and one group column}

\item{threads}{default:4}

\item{file}{filename to save}

\item{rep}{repeat numbers: suggest 999}

\item{save}{save the file}

\item{x}{NTI_RC object}

\item{...}{pass to \code{\link[pcutils]{stackplot}}}
}
\value{
a b_dist object, dis is MSTij

ggplot
}
\description{
Calculate b_NTI and RC_bray for each group

Plot NTI_RC object
}
\examples{
\donttest{
if (requireNamespace("NST") && requireNamespace("pctax")) {
  data(otutab, package = "pcutils")
  pctax::df2tree(taxonomy) -> phylo
  nti_rc(otutab, phylo, metadata["Group"]) -> nti_res
  plot(nti_res)
}
}
}
\references{
Ning, D., Deng, Y., Tiedje, J. M. & Zhou, J. (2019) A general framework for quantitatively assessing ecological stochasticity. Proceedings of the National Academy of Sciences 116, 16892–16898.
}
