% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AuxDelaunay.R
\name{index.six.Te}
\alias{index.six.Te}
\title{Region index inside the Gamma-1 region}
\usage{
index.six.Te(p)
}
\arguments{
\item{p}{A 2D point whose index for the 6 regions
in standard equilateral triangle \eqn{T_e} is determined.}
}
\value{
rel An integer between 1-6 (inclusive) or \code{NA}
}
\description{
Returns the region index of the point \code{p}
for the 6 regions in standard equilateral triangle
\eqn{T_e=T((0,0),(1,0),(1/2,\sqrt{3}/2))},
starting with 1 on the first one-sixth of the triangle,
and numbering follows the counter-clockwise direction
(see the plot in the examples).
These regions are in the inner hexagon
which is the Gamma-1 region for CS-PCD with \eqn{t=1}
if \code{p} is not in any of the 6 regions the function returns \code{NA}.
}
\examples{
\dontrun{
P<-c(.4,.2)
index.six.Te(P)

A<-c(0,0); B<-c(1,0); C<-c(0.5,sqrt(3)/2);
Te<-rbind(A,B,C)
CM<-(A+B+C)/3
D1<-(B+C)/2; D2<-(A+C)/2; D3<-(A+B)/2;
Ds<-rbind(D1,D2,D3)

h1<-c(1/2,sqrt(3)/18); h2<-c(2/3, sqrt(3)/9); h3<-c(2/3, 2*sqrt(3)/9);
h4<-c(1/2, 5*sqrt(3)/18); h5<-c(1/3, 2*sqrt(3)/9); h6<-c(1/3, sqrt(3)/9);

r1<-(h1+h6+CM)/3;r2<-(h1+h2+CM)/3;r3<-(h2+h3+CM)/3;
r4<-(h3+h4+CM)/3;r5<-(h4+h5+CM)/3;r6<-(h5+h6+CM)/3;

Xlim<-range(Te[,1])
Ylim<-range(Te[,2])
xd<-Xlim[2]-Xlim[1]
yd<-Ylim[2]-Ylim[1]

plot(A,pch=".",xlab="",ylab="",axes=TRUE,xlim=Xlim+xd*c(-.05,.05),ylim=Ylim+yd*c(-.05,.05))
polygon(Te)
L<-Te; R<-Ds
segments(L[,1], L[,2], R[,1], R[,2], lty = 2)
polygon(rbind(h1,h2,h3,h4,h5,h6))

txt<-rbind(h1,h2,h3,h4,h5,h6)
xc<-txt[,1]+c(-.02,.02,.02,0,0,0)
yc<-txt[,2]+c(.02,.02,.02,0,0,0)
txt.str<-c("h1","h2","h3","h4","h5","h6")
text(xc,yc,txt.str)

txt<-rbind(Te,CM,r1,r2,r3,r4,r5,r6)
xc<-txt[,1]+c(-.02,.02,.02,0,0,0,0,0,0,0)
yc<-txt[,2]+c(.02,.02,.02,0,0,0,0,0,0,0)
txt.str<-c("A","B","C","CM","1","2","3","4","5","6")
text(xc,yc,txt.str)

n<-10  #try also n<-40
Xp<-runif.std.tri(n)$gen.points

Xlim<-range(Te[,1],Xp[,1])
Ylim<-range(Te[,2],Xp[,2])
xd<-Xlim[2]-Xlim[1]
yd<-Ylim[2]-Ylim[1]

rsix<-vector()
for (i in 1:n)
  rsix<-c(rsix,index.six.Te(Xp[i,]))
rsix

plot(A,pch=".",xlab="",ylab="",axes=TRUE,xlim=Xlim+xd*c(-.05,.05),ylim=Ylim+yd*c(-.05,.05))
polygon(Te)
points(Xp,pch=".")
L<-Te; R<-Ds
segments(L[,1], L[,2], R[,1], R[,2], lty = 2)
polygon(rbind(h1,h2,h3,h4,h5,h6))
text(Xp,labels=factor(rsix))

txt<-rbind(Te,CM)
xc<-txt[,1]+c(-.02,.02,.02,0)
yc<-txt[,2]+c(.02,.02,.02,-.05)
txt.str<-c("A","B","C","CM")
text(xc,yc,txt.str)
}

}
\seealso{
\code{\link{runif.std.tri.onesixth}}
}
\author{
Elvan Ceyhan
}
