% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCDFunctions.r
\name{redge.triCM}
\alias{redge.triCM}
\title{The vertices of the \eqn{CM}-edge region in a triangle that contains the point}
\usage{
redge.triCM(pt, tri)
}
\arguments{
\item{pt}{A 2D point for which \eqn{CM}-edge region it resides in is to be determined in the triangle \code{tri}.}

\item{tri}{Three 2D points, stacked row-wise, each row representing a vertex of the triangle.}
}
\value{
The \eqn{CM}-edge region that contains point, \code{pt} in the triangle \code{tri}. The related edges are given as
vertices \code{ABC} for \eqn{re=3}, as \code{BCA} for \eqn{re=1} and as \code{CAB} for \eqn{re=2} where edges are labeled as 3
for edge \eqn{AB}, 1 for edge \eqn{BC}, and 2 for edge \eqn{AC}.
}
\description{
Returns the edge whose region contains point, \code{pt}, in
the triangle \code{tri}\eqn{=T(A,B,C)} with edge regions based on center of mass \eqn{CM=(A+B+C)/3}.

This function is related to \code{\link{re.triCM}}, but unlike \code{\link{re.triCM}} the related edges are given as vertices \code{ABC}
for \eqn{re=3}, as \code{BCA} for \eqn{re=1} and as \code{CAB} for \eqn{re=2} where edges are labeled as 3 for edge \eqn{AB}, 1 for edge \eqn{BC},
and 2 for edge \eqn{AC}. The vertices are given one vertex in each row in the output, e.g., \eqn{ABC} is printed
as \code{rbind(A,B,C)}, where row 1 has the entries of vertex A, row 2 has the entries of vertex B,
and row 3 has the entries of vertex C.

If the point, \code{pt}, is not inside \code{tri}, then the function yields \code{NA} as output.

Edge region for BCA is the triangle \eqn{T(B,C,CM)}, edge region CAB is \eqn{T(A,C,CM)}, and edge region ABC is \eqn{T(A,B,CM)}.

See also (\insertCite{ceyhan:Phd-thesis,ceyhan:comp-geo-2010,ceyhan:mcap2012;textual}{pcds}).
}
\examples{
A<-c(1,1); B<-c(2,0); C<-c(1.5,2);
Tr<-rbind(A,B,C);

P<-c(.4,.2)  #try also P<-as.numeric(runif.tri(1,Tr)$g)
redge.triCM(P,Tr)

P<-c(.8,.2)
redge.triCM(P,Tr)

P<-c(.5,.61)
redge.triCM(P,Tr)

CM<-(A+B+C)/3
p1<-(A+B+CM)/3
p2<-(B+C+CM)/3
p3<-(A+C+CM)/3

Xlim<-range(Tr[,1])
Ylim<-range(Tr[,2])
xd<-Xlim[2]-Xlim[1]
yd<-Ylim[2]-Ylim[1]

plot(Tr,pch=".",xlab="",ylab="",axes=TRUE,xlim=Xlim+xd*c(-.05,.05),ylim=Ylim+yd*c(-.05,.05))
polygon(Tr)
L<-Tr; R<-matrix(rep(CM,3),ncol=2,byrow=TRUE)
segments(L[,1], L[,2], R[,1], R[,2], lty=2)

txt<-rbind(Tr,CM,p1,p2,p3)
xc<-txt[,1]+c(-.02,.02,.02,.05,0,0,0)
yc<-txt[,2]+c(.02,.02,.02,.02,0,0,0)
txt.str<-c("A","B","C","CM","re=y1y2y3","re=y2y3y1","re=y3y1y2")
text(xc,yc,txt.str)

dat.fr<-data.frame(a=Tr)
redge.triCM(P,dat.fr)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{re.tri.cent}}, \code{\link{re.triCM}}, \code{\link{re.bastriCM}},
\code{\link{re.bastri.cent}}, \code{\link{reTeCM}}, and \code{\link{redge.triCM}}
}
\author{
Elvan Ceyhan
}
