% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCDFunctions.r
\name{area.polygon}
\alias{area.polygon}
\title{The area of a polygon in \eqn{R^2}}
\usage{
area.polygon(h)
}
\arguments{
\item{h}{A \code{vector} of \eqn{n} 2D points, stacked row-wise, each row representing a vertex of the polygon,
where \eqn{n} is the number of vertices of the polygon.}
}
\value{
area of the polygon \code{h}
}
\description{
Returns the area of the polygon, \code{h}, in the real plane \eqn{R^{2}}; the vertices of the polygon \code{h}
must be provided in clockwise or counter-clockwise order, otherwise the function does not yield
the area of the polygon. Also, the polygon could be convex or non-convex.
See (\insertCite{weisstein-area-poly;textual}{pcds}).
}
\examples{
A<-c(0,0); B<-c(1,0); C<-c(0.5,.8);
Tr<-rbind(A,B,C);
area.polygon(Tr)

A<-c(0,0); B<-c(1,0); C<-c(.7,.6); D<-c(0.3,.8);
h1<-rbind(A,B,C,D);  #try also h1<-rbind(A,B,D,C) or h1<-rbind(A,C,B,D) or h1<-rbind(A,D,C,B);
area.polygon(h1)

Xlim<-range(h1[,1])
Ylim<-range(h1[,2])
xd<-Xlim[2]-Xlim[1]
yd<-Ylim[2]-Ylim[1]

plot(h1,xlab="",ylab="",xlim=Xlim+xd*c(-.05,.05),ylim=Ylim+yd*c(-.05,.05))
polygon(h1)
xc<-rbind(A,B,C,D)[,1]+c(-.03,.03,.02,-.01)
yc<-rbind(A,B,C,D)[,2]+c(.02,.02,.02,.04)
txt.str<-c("A","B","C","D")
text(xc,yc,txt.str)

dat.fr<-data.frame(a=Tr)
area.polygon(dat.fr)

#when the triangle is degenerate, it gives zero area
B<-A+2*(C-A);
T2<-rbind(A,B,C)
area.polygon(T2)

}
\references{
\insertAllCited{}
}
\author{
Elvan Ceyhan
}
